/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.mixin;

import com.mojang.datafixers.util.Pair;
import com.structureessentials.StructureEssentials;
import com.structureessentials.config.CommonConfiguration;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2794.class})
public class StructureSearchTimeoutMixin {
    @Unique
    private long time = 0L;
    @Unique
    private static long staticTime = 0L;

    @Inject(method={"getNearestGeneratedStructure(Ljava/util/Set;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/levelgen/structure/placement/ConcentricRingsStructurePlacement;)Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="HEAD")})
    private void onSearchStart(Set<class_6880<class_3195>> p_223182_, class_3218 p_223183_, class_5138 p_223184_, class_2338 p_223185_, boolean p_223186_, class_6871 p_223187_, CallbackInfoReturnable<Pair<class_2338, class_6880<class_3195>>> cir) {
        this.time = System.currentTimeMillis();
    }

    @Inject(method={"getNearestGeneratedStructure(Ljava/util/Set;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/levelgen/structure/placement/ConcentricRingsStructurePlacement;)Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkGenerator;getStructureGeneratingAt(Ljava/util/Set;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/world/level/StructureManager;ZLnet/minecraft/world/level/levelgen/structure/placement/StructurePlacement;Lnet/minecraft/world/level/ChunkPos;)Lcom/mojang/datafixers/util/Pair;")}, cancellable=true)
    private void onSearchTiming(Set<class_6880<class_3195>> holderSet, class_3218 p_223183_, class_5138 p_223184_, class_2338 p_223185_, boolean p_223186_, class_6871 p_223187_, CallbackInfoReturnable<Pair<class_2338, class_6880<class_3195>>> cir) {
        if (this.time != 0L && System.currentTimeMillis() - this.time > (long)((CommonConfiguration)StructureEssentials.config.getCommonConfig()).structureSearchTimeout * 1000L) {
            StructureEssentials.LOGGER.info("Structure searched for " + StructureSearchTimeoutMixin.getStructurename(holderSet) + " timed out, took: " + (System.currentTimeMillis() - this.time) / 1000L + " seconds.");
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getNearestGeneratedStructure(Ljava/util/Set;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/world/level/StructureManager;IIIZJLnet/minecraft/world/level/levelgen/structure/placement/RandomSpreadStructurePlacement;)Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="HEAD")})
    private static void onSearchStartStatic(Set<class_6880<class_3195>> p_223189_, class_4538 p_223190_, class_5138 p_223191_, int p_223192_, int p_223193_, int p_223194_, boolean p_223195_, long p_223196_, class_6872 p_223197_, CallbackInfoReturnable<Pair<class_2338, class_6880<class_3195>>> cir) {
        staticTime = System.currentTimeMillis();
    }

    @Inject(method={"getNearestGeneratedStructure(Ljava/util/Set;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/world/level/StructureManager;IIIZJLnet/minecraft/world/level/levelgen/structure/placement/RandomSpreadStructurePlacement;)Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkGenerator;getStructureGeneratingAt(Ljava/util/Set;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/world/level/StructureManager;ZLnet/minecraft/world/level/levelgen/structure/placement/StructurePlacement;Lnet/minecraft/world/level/ChunkPos;)Lcom/mojang/datafixers/util/Pair;")})
    private static void onSearchStartStaticTiming(Set<class_6880<class_3195>> holderSet, class_4538 p_223190_, class_5138 p_223191_, int p_223192_, int p_223193_, int p_223194_, boolean p_223195_, long p_223196_, class_6872 p_223197_, CallbackInfoReturnable<Pair<class_2338, class_6880<class_3195>>> cir) {
        if (staticTime != 0L && System.currentTimeMillis() - staticTime > (long)((CommonConfiguration)StructureEssentials.config.getCommonConfig()).structureSearchTimeout * 1000L) {
            StructureEssentials.LOGGER.info("Structure searched for " + StructureSearchTimeoutMixin.getStructurename(holderSet) + " timed out, took: " + (System.currentTimeMillis() - staticTime) / 1000L + " seconds.");
            cir.setReturnValue(null);
        }
    }

    @Unique
    private static String getStructurename(Set<class_6880<class_3195>> holderSet) {
        for (class_6880<class_3195> holder : holderSet) {
            if (!holder.method_40230().isPresent()) continue;
            return ((class_5321)holder.method_40230().get()).method_29177().toString();
        }
        return "unkown structure";
    }
}

