/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.systems.fluid;

import com.hypherionmc.craterlib.core.systems.fluid.FluidHolder;
import com.hypherionmc.craterlib.core.systems.fluid.ICraterFluidHandler;
import com.hypherionmc.craterlib.util.FluidUtils;
import java.util.function.Predicate;
import net.minecraft.class_2487;

public class CraterFluidTank
implements ICraterFluidHandler {
    private final int capacity;
    private final Predicate<FluidHolder> validFluid;
    private FluidHolder fluid = FluidHolder.EMPTY;
    private ChangeListener contentsChanged;

    public CraterFluidTank(int capacity) {
        this(capacity, e -> true);
    }

    public CraterFluidTank(int capacity, Predicate<FluidHolder> validFluid) {
        this.capacity = capacity;
        this.validFluid = validFluid;
    }

    public boolean isValidFluid(FluidHolder variant) {
        return this.validFluid.test(variant);
    }

    @Override
    public int insert(FluidHolder fluidHolder, ICraterFluidHandler.FluidAction action) {
        if (fluidHolder.isEmpty() || !this.isValidFluid(fluidHolder)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, fluidHolder.getAmount());
            }
            if (!this.fluid.isFluidEqual(fluidHolder)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), fluidHolder.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = new FluidHolder(fluidHolder.getFluid(), Math.min(this.capacity, fluidHolder.getAmount()));
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(fluidHolder)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (fluidHolder.getAmount() < filled) {
            this.fluid.grow(fluidHolder.getAmount());
            filled = fluidHolder.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
            filled = this.capacity;
        }
        if (filled > 0 && this.contentsChanged != null) {
            this.contentsChanged.onContentsChanged();
        }
        return filled;
    }

    @Override
    public FluidHolder extract(FluidHolder resource, ICraterFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidHolder.EMPTY;
        }
        return this.extract(resource.getAmount(), action);
    }

    @Override
    public FluidHolder extract(int amount, ICraterFluidHandler.FluidAction action) {
        int drained = amount;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidHolder holder = new FluidHolder(this.fluid, drained);
        if (action.execute() && drained > 0) {
            this.fluid.shrink(drained);
        }
        if (this.contentsChanged != null) {
            this.contentsChanged.onContentsChanged();
        }
        return holder;
    }

    public void setContainedFluid(FluidHolder fluid) {
        this.fluid = fluid;
    }

    @Override
    public boolean isTankEmpty() {
        return this.fluid.isEmpty();
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.fluid.getAmount());
    }

    @Override
    public FluidHolder getFluidInTank() {
        return this.fluid;
    }

    @Override
    public int getTankLevel() {
        return this.fluid.getAmount();
    }

    @Override
    public int getTankCapacity() {
        return this.capacity;
    }

    @Override
    public class_2487 writeToNBT(class_2487 tag) {
        FluidUtils.putFluid(tag, "fluid", this.fluid.getFluid());
        tag.method_10569("tankLevel", this.fluid.getAmount());
        return tag;
    }

    @Override
    public void readFromNBT(class_2487 tag) {
        this.fluid = new FluidHolder(FluidUtils.getFluidCompatible(tag), tag.method_10550("tankLevel"));
    }

    public void setChangeListener(ChangeListener contentsChanged) {
        this.contentsChanged = contentsChanged;
    }

    public static interface ChangeListener {
        public void onContentsChanged();
    }
}

