/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.network;

import com.google.common.collect.Maps;
import com.hypherionmc.craterlib.core.network.CraterNetworkHandler;
import com.hypherionmc.craterlib.core.network.CraterPacket;
import com.hypherionmc.craterlib.core.network.PacketDirection;
import com.hypherionmc.craterlib.network.FabricNetworkHelper;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public class FabricNetworkHandler
implements CraterNetworkHandler {
    private static final Map<String, FabricNetworkHandler> NETWORK_HANDLERS = Maps.newConcurrentMap();
    private final Map<Class<? extends CraterPacket<?>>, PacketData> packets = Maps.newIdentityHashMap();
    private final String modid;
    private final AtomicInteger packetID = new AtomicInteger();

    private FabricNetworkHandler(String modid) {
        this.modid = modid;
    }

    @Override
    public <T extends CraterPacket<T>> void registerPacket(Class<? extends T> clazz, Supplier<T> supplier, PacketDirection packetDirection) {
        class_2960 channelName = this.nextId();
        this.packets.put(clazz, new PacketData(clazz, channelName, packetDirection));
        Function<class_2540, CraterPacket<?>> decoder = buf -> (CraterPacket)class_156.method_654((Object)((CraterPacket)supplier.get()), message -> message.read((class_2540)buf));
        switch (packetDirection) {
            case TO_CLIENT: {
                FabricNetworkHelper.getForDist(FabricLoader.getInstance().getEnvironmentType()).registerClientReceiver(channelName, decoder);
                break;
            }
            case TO_SERVER: {
                FabricNetworkHelper.getForDist(FabricLoader.getInstance().getEnvironmentType()).registerServerReceiver(channelName, decoder);
            }
        }
    }

    private class_2960 nextId() {
        return new class_2960(this.modid, "play/" + this.packetID.getAndIncrement());
    }

    @Override
    public class_2596<?> toServerBound(CraterPacket<?> packet) {
        if (this.packets.get(packet.getClass()).direction() != PacketDirection.TO_SERVER) {
            throw new IllegalStateException("Attempted sending message to wrong side, expected %s, was %s".formatted(new Object[]{PacketDirection.TO_SERVER, PacketDirection.TO_CLIENT}));
        }
        return this.toPacket(ClientPlayNetworking::createC2SPacket, packet);
    }

    @Override
    public class_2596<?> toClientBound(CraterPacket<?> packet) {
        if (this.packets.get(packet.getClass()).direction() != PacketDirection.TO_CLIENT) {
            throw new IllegalStateException("Attempted sending message to wrong side, expected %s, was %s".formatted(new Object[]{PacketDirection.TO_CLIENT, PacketDirection.TO_SERVER}));
        }
        return this.toPacket(ServerPlayNetworking::createS2CPacket, packet);
    }

    private class_2596<?> toPacket(BiFunction<class_2960, class_2540, class_2596<?>> packetFactory, CraterPacket<?> message) {
        class_2960 identifier = this.packets.get(message.getClass()).identifier();
        class_2540 byteBuf = PacketByteBufs.create();
        message.write(byteBuf);
        return packetFactory.apply(identifier, byteBuf);
    }

    public static synchronized CraterNetworkHandler of(String modId) {
        return NETWORK_HANDLERS.computeIfAbsent(modId, FabricNetworkHandler::new);
    }

    private record PacketData(Class<? extends CraterPacket<?>> clazz, class_2960 identifier, PacketDirection direction) {
    }
}

