/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.systems.fluid;

import com.hypherionmc.craterlib.core.systems.fluid.CraterFluidTank;
import com.hypherionmc.craterlib.core.systems.fluid.FluidHolder;
import com.hypherionmc.craterlib.core.systems.fluid.ICraterFluidHandler;
import java.util.Iterator;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3611;

public class FluidTank
extends CraterFluidTank
implements Storage<FluidVariant>,
StorageView<FluidVariant> {
    public FluidTank(long capacity) {
        this(capacity, (FluidVariant e) -> true);
    }

    public FluidTank(long capacity, Predicate<FluidVariant> validFluid) {
        super((int)capacity, (FluidHolder p) -> validFluid.test(FluidVariant.of((class_3611)p.getFluid())));
    }

    public boolean isFluidValid(FluidVariant variant) {
        return this.isValidFluid(new FluidHolder(variant.getFluid(), 0));
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        return this.insert(new FluidHolder(resource.getFluid(), (int)maxAmount), ICraterFluidHandler.FluidAction.EXECUTE);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        FluidHolder extracted = this.extract(new FluidHolder(resource.getFluid(), (int)maxAmount), ICraterFluidHandler.FluidAction.EXECUTE);
        return extracted.getAmount();
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return null;
    }

    public boolean isResourceBlank() {
        return this.isTankEmpty();
    }

    public FluidVariant getResource() {
        return FluidVariant.of((class_3611)this.getFluidInTank().getFluid());
    }

    public long getAmount() {
        return this.getTankLevel();
    }

    public long getCapacity() {
        return this.getTankCapacity();
    }
}

