/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.apache.commons.lang3.mutable.MutableInt;

public class RewardTablesScreen
extends ButtonListBaseScreen {
    private final QuestScreen questScreen;

    public RewardTablesScreen(QuestScreen questScreen) {
        this.questScreen = questScreen;
        this.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.reward_tables"));
        this.setHasSearchBox(true);
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        SimpleTextButton button = new SimpleTextButton(panel, (class_2561)class_2561.method_43471((String)"gui.add"), Icons.ADD){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                StringConfig c = new StringConfig();
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                    if (accepted) {
                        RewardTable table = new RewardTable(0L, ClientQuestFile.INSTANCE);
                        table.setRawTitle((String)c.getValue());
                        new CreateObjectMessage(table, null).sendToServer();
                    }
                    this.openGui();
                });
            }
        };
        button.setHeight(14);
        panel.add((Widget)button);
        ClientQuestFile.INSTANCE.getRewardTables().forEach(table -> panel.add((Widget)new RewardTableButton(panel, (RewardTable)table)));
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return super.keyPressed(key);
    }

    private class RewardTableButton
    extends SimpleTextButton {
        private final RewardTable table;

        public RewardTableButton(Panel panel, RewardTable table) {
            super(panel, table.getTitle(), table.getIcon());
            this.table = table;
            this.setHeight(14);
            if (this.table.getLootCrate() != null) {
                this.title = this.title.method_27661().method_27692(class_124.field_1054);
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (button.isLeft()) {
                this.table.onEditButtonClicked((Runnable)((Object)this));
                return;
            }
            ContextMenuBuilder.create(this.table, RewardTablesScreen.this.questScreen).insertAtBottom(List.of(new ContextMenuItem((class_2561)class_2561.method_43471((String)"item.ftbquests.lootcrate"), Icons.ACCEPT, this::toggleLootCrate){

                public void drawIcon(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                    (RewardTableButton.this.table.getLootCrate() != null ? Icons.ACCEPT : Icons.ACCEPT_GRAY).draw(graphics, x, y, w, h);
                }
            })).openContextMenu((BaseScreen)RewardTablesScreen.this);
        }

        private void toggleLootCrate() {
            LootCrate crate = this.table.toggleLootCrate();
            this.title = crate != null ? this.table.getMutableTitle().method_27692(class_124.field_1054) : this.table.getTitle();
            new EditObjectMessage(this.table).sendToServer();
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            MutableInt usedIn = new MutableInt(0);
            ClientQuestFile.INSTANCE.forAllQuests(quest -> quest.getRewards().stream().filter(reward -> {
                RandomReward rr;
                return reward instanceof RandomReward && (rr = (RandomReward)reward).getTable() == this.table;
            }).forEach(reward -> usedIn.increment()));
            if (usedIn.intValue() > 0) {
                list.add((class_2561)class_2561.method_43469((String)"ftbquests.reward_table.used_in", (Object[])new Object[]{usedIn}).method_27692(class_124.field_1080));
            }
            this.table.addMouseOverText(list, true, true);
        }
    }
}

