/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;

public final class ChapterImage
implements Movable {
    private static final Pattern COLOR_PATTERN = Pattern.compile("^#[a-fA-F0-9]{6}$");
    private Chapter chapter;
    private double x;
    private double y;
    private double width;
    private double height;
    private double rotation;
    private Icon image;
    private Color4I color;
    private int alpha;
    private final List<String> hover;
    private String click;
    private boolean editorsOnly;
    private boolean alignToCorner;
    private Quest dependency;
    private double aspectRatio;
    private boolean needAspectRecalc;
    private int order;

    public ChapterImage(Chapter c) {
        this.chapter = c;
        this.y = 0.0;
        this.x = 0.0;
        this.width = 1.0;
        this.height = 1.0;
        this.rotation = 0.0;
        this.image = Color4I.empty();
        this.color = Color4I.WHITE;
        this.alpha = 255;
        this.needAspectRecalc = true;
        this.hover = new ArrayList<String>();
        this.click = "";
        this.editorsOnly = false;
        this.alignToCorner = false;
        this.dependency = null;
        this.order = 0;
    }

    public Icon getImage() {
        return this.image;
    }

    public ChapterImage setImage(Icon image) {
        this.image = image;
        this.needAspectRecalc = true;
        return this;
    }

    public ChapterImage setPosition(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Color4I getColor() {
        return this.color;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getOrder() {
        return this.order;
    }

    public double getRotation() {
        return this.rotation;
    }

    public boolean isAlignToCorner() {
        return this.alignToCorner;
    }

    public String getClick() {
        return this.click;
    }

    public void addHoverText(TooltipList list) {
        this.hover.forEach(arg_0 -> ((TooltipList)list).string(arg_0));
    }

    public class_2487 writeData(class_2487 nbt) {
        nbt.method_10549("x", this.x);
        nbt.method_10549("y", this.y);
        nbt.method_10549("width", this.width);
        nbt.method_10549("height", this.height);
        nbt.method_10549("rotation", this.rotation);
        nbt.method_10582("image", this.image.toString());
        if (!this.color.equals((Object)Color4I.WHITE)) {
            nbt.method_10569("color", this.color.rgb());
        }
        if (this.alpha != 255) {
            nbt.method_10569("alpha", this.alpha);
        }
        if (this.order != 0) {
            nbt.method_10569("order", this.order);
        }
        class_2499 hoverTag = new class_2499();
        for (String s : this.hover) {
            hoverTag.add((Object)class_2519.method_23256((String)s));
        }
        nbt.method_10566("hover", (class_2520)hoverTag);
        nbt.method_10582("click", this.click);
        nbt.method_10556("dev", this.editorsOnly);
        nbt.method_10556("corner", this.alignToCorner);
        if (this.dependency != null) {
            nbt.method_10582("dependency", this.dependency.getCodeString());
        }
        return nbt;
    }

    public void readData(class_2487 nbt) {
        this.x = nbt.method_10574("x");
        this.y = nbt.method_10574("y");
        this.width = nbt.method_10574("width");
        this.height = nbt.method_10574("height");
        this.rotation = nbt.method_10574("rotation");
        this.setImage(Icon.getIcon((String)nbt.method_10558("image")));
        this.color = nbt.method_10545("color") ? Color4I.rgb((int)nbt.method_10550("color")) : Color4I.WHITE;
        this.alpha = nbt.method_10545("alpha") ? nbt.method_10550("alpha") : 255;
        this.order = nbt.method_10550("order");
        this.hover.clear();
        class_2499 hoverTag = nbt.method_10554("hover", 8);
        for (int i = 0; i < hoverTag.size(); ++i) {
            this.hover.add(hoverTag.method_10608(i));
        }
        this.click = nbt.method_10558("click");
        this.editorsOnly = nbt.method_10577("dev");
        this.alignToCorner = nbt.method_10577("corner");
        this.dependency = nbt.method_10545("dependency") ? this.chapter.file.getQuest(this.chapter.file.getID(nbt.method_10580("dependency"))) : null;
    }

    public void writeNetData(class_2540 buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.width);
        buffer.writeDouble(this.height);
        buffer.writeDouble(this.rotation);
        NetUtils.writeIcon(buffer, this.image);
        buffer.writeInt(this.color.rgb());
        buffer.writeInt(this.alpha);
        buffer.writeInt(this.order);
        NetUtils.writeStrings(buffer, this.hover);
        buffer.method_10788(this.click, Short.MAX_VALUE);
        buffer.writeBoolean(this.editorsOnly);
        buffer.writeBoolean(this.alignToCorner);
        buffer.writeLong(this.dependency == null ? 0L : this.dependency.id);
    }

    public void readNetData(class_2540 buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.width = buffer.readDouble();
        this.height = buffer.readDouble();
        this.rotation = buffer.readDouble();
        this.setImage(NetUtils.readIcon(buffer));
        this.color = Color4I.rgb((int)buffer.readInt());
        this.alpha = buffer.readInt();
        this.order = buffer.readInt();
        NetUtils.readStrings(buffer, this.hover);
        this.click = buffer.method_10800(Short.MAX_VALUE);
        this.editorsOnly = buffer.readBoolean();
        this.alignToCorner = buffer.readBoolean();
        this.dependency = this.chapter.file.getQuest(buffer.readLong());
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("width", this.width, v -> {
            this.width = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("height", this.height, v -> {
            this.height = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("rotation", this.rotation, v -> {
            this.rotation = v;
        }, 0.0, -180.0, 180.0);
        config.add("image", (ConfigValue)new ImageConfig(), (Object)(this.image instanceof Color4I ? "" : this.image.toString()), v -> this.setImage(Icon.getIcon((String)v)), (Object)"minecraft:textures/gui/presets/isles.png");
        config.addString("color", this.color.toString(), v -> {
            this.color = Color4I.fromString((String)v);
        }, "#FFFFFF", COLOR_PATTERN);
        config.addInt("order", this.order, v -> {
            this.order = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("alpha", this.alpha, v -> {
            this.alpha = v;
        }, 255, 0, 255);
        config.addList("hover", this.hover, (ConfigValue)new StringConfig(), (Object)"");
        config.addString("click", this.click, v -> {
            this.click = v;
        }, "");
        config.addBool("dev", this.editorsOnly, v -> {
            this.editorsOnly = v;
        }, false);
        config.addBool("corner", this.alignToCorner, v -> {
            this.alignToCorner = v;
        }, false);
        Predicate<QuestObjectBase> depTypes = object -> object == null || object instanceof Quest;
        ((ConfigQuestObject)config.add("dependency", new ConfigQuestObject(depTypes), (Object)this.dependency, v -> {
            this.dependency = v;
        }, null)).setNameKey("ftbquests.dependency");
    }

    @Override
    public long getMovableID() {
        return 0L;
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public String getShape() {
        return "square";
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void move(Chapter to, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        if (to != this.chapter) {
            this.chapter.removeImage(this);
            new EditObjectMessage(this.chapter).sendToServer();
            this.chapter = to;
            this.chapter.addImage(this);
        }
        new EditObjectMessage(this.chapter).sendToServer();
    }

    @Override
    public void onMoved(double x, double y, long chapterId) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawMoved(class_332 graphics) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        if (this.alignToCorner) {
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.rotation));
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(graphics, 0, 0, 1, 1);
        } else {
            poseStack.method_22904(0.5, 0.5, 0.0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.rotation));
            poseStack.method_22905(0.5f, 0.5f, 1.0f);
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(graphics, -1, -1, 2, 2);
        }
        poseStack.method_22909();
        QuestShape.get(this.getShape()).getOutline().withColor(Color4I.WHITE.withAlpha(30)).draw(graphics, 0, 0, 1, 1);
    }

    public boolean isAspectRatioOff() {
        return this.image.hasPixelBuffer() && !class_3532.method_20390((double)this.getAspectRatio(), (double)(this.width / this.height));
    }

    public void fixupAspectRatio(boolean adjustWidth) {
        if (this.isAspectRatioOff()) {
            if (adjustWidth) {
                this.width = this.height * this.getAspectRatio();
            } else {
                this.height = this.width / this.getAspectRatio();
            }
            new EditObjectMessage(this.chapter).sendToServer();
        }
    }

    private double getAspectRatio() {
        if (this.needAspectRecalc) {
            PixelBuffer buffer = this.image.createPixelBuffer();
            this.aspectRatio = buffer != null ? (double)buffer.getWidth() / (double)buffer.getHeight() : 1.0;
            this.needAspectRecalc = false;
        }
        return this.aspectRatio;
    }

    public ChapterImage copy(Chapter newChapter, double newX, double newY) {
        ChapterImage copy = new ChapterImage(newChapter);
        copy.readData(this.writeData(new class_2487()));
        copy.setPosition(newX, newY);
        return copy;
    }

    public boolean shouldShowImage(TeamData teamData) {
        return !this.editorsOnly && (this.dependency == null || teamData.isCompleted(this.dependency));
    }
}

