/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.PurpleSpikeEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;

public class EssenceBlockPurple
extends EssenceBlock {
    public static final int INTERVALS = 36;

    public EssenceBlockPurple() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16014));
    }

    @Override
    public class_2960 getArenaNbt() {
        return new class_2960("the_bumblezone", "essence/purple_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 5020;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.purple_essence_event", class_1259.class_1260.field_5783, class_1259.class_1261.field_5795).method_5406(true);
    }

    @Override
    public class_1799 getEssenceItemReward() {
        return BzItems.ESSENCE_KNOWING.get().method_7854();
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(class_3222 serverPlayer) {
        serverPlayer.method_7281(BzStats.KNOWING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        int timeRemaining = essenceBlockEntity.getEventTimer();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (eventEntitiesInArena.isEmpty()) {
            EssenceBlockPurple.spawnEntities(serverLevel, blockPos, essenceBlockEntity, eventEntitiesInArena, false);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                class_1297 entity = serverLevel.method_14190(entityToCheck);
                if (entity == null) {
                    List nearbyRings = serverLevel.method_18467(PurpleSpikeEntity.class, new class_238((double)((float)blockPos.method_10263() - (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() - (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() - (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f), (double)((float)blockPos.method_10263() + (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() + (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() + (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f)));
                    for (PurpleSpikeEntity nearbySpike : nearbyRings) {
                        if (!nearbySpike.method_5667().equals(entityToCheck) || !nearbySpike.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                        entity = nearbySpike;
                        break;
                    }
                }
                if (entity != null) continue;
                for (int k = eventEntitiesInArena.size() - 1; k >= 0; --k) {
                    UUID entityUUIDToRemove = eventEntitiesInArena.remove(k).uuid();
                    class_1297 entityEntityToRemove = serverLevel.method_14190(entityUUIDToRemove);
                    if (entityEntityToRemove == null) continue;
                    entityEntityToRemove.method_5650(class_1297.class_5529.field_26999);
                }
                EssenceBlockPurple.spawnEntities(serverLevel, blockPos, essenceBlockEntity, eventEntitiesInArena, true);
                break;
            }
            EssenceBlockPurple.ravingTime(serverLevel, timeRemaining, this.getEventTimeFrame(), essenceBlockEntity, eventEntitiesInArena);
        }
        if (timeRemaining == 0) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
        essenceBlockEntity.getEventBar().method_5408((float)essenceBlockEntity.getEventTimer() / (float)this.getEventTimeFrame());
    }

    private static void spawnEntities(class_3218 serverLevel, class_2338 blockPos, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, boolean punish) {
        class_2338 arenaSize = essenceBlockEntity.getArenaSize();
        int rowLength = arenaSize.method_10263() - 2;
        int columnLength = arenaSize.method_10260() - 2;
        for (int x = 0; x < rowLength; ++x) {
            for (int z = 0; z < columnLength; ++z) {
                PurpleSpikeEntity spikeEntity = (PurpleSpikeEntity)BzEntities.PURPLE_SPIKE_ENTITY.get().method_5883((class_1937)serverLevel);
                if (spikeEntity == null) continue;
                spikeEntity.setEssenceController(essenceBlockEntity.getUUID());
                spikeEntity.setEssenceControllerBlockPos(essenceBlockEntity.method_11016());
                spikeEntity.setEssenceControllerDimension((class_5321<class_1937>)serverLevel.method_27983());
                spikeEntity.method_5814((double)blockPos.method_10263() - Math.floor((double)arenaSize.method_10263() / 2.0) + 1.0 + (double)x + 0.5, (double)blockPos.method_10264() - Math.floor((double)arenaSize.method_10264() / 2.0) + 1.0, (double)blockPos.method_10260() - Math.floor((double)arenaSize.method_10260() / 2.0) + 1.0 + (double)z + 0.5);
                eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(spikeEntity.method_5667()));
                if (punish) {
                    spikeEntity.setSpikeTimer(50);
                }
                serverLevel.method_30771((class_1297)spikeEntity);
            }
        }
    }

    private static void ravingTime(class_3218 serverLevel, int timeRemaining, int eventTimeFrame, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        int currentTime = eventTimeFrame - timeRemaining + 5;
        if (currentTime % 36 == 0) {
            int arenaRadiusSq;
            int intervalOffset;
            class_2338 arenaSize = essenceBlockEntity.getArenaSize();
            int rowLength = arenaSize.method_10263() - 2;
            int columnLength = arenaSize.method_10260() - 2;
            int xRadius = rowLength / 2;
            int zRadius = columnLength / 2;
            int interval = currentTime / 36;
            if (interval < 8 && interval >= 0) {
                intervalOffset = interval - 2;
                arenaRadiusSq = xRadius * xRadius + zRadius * zRadius;
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, 0, false);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -3, false);
            }
            if (interval < 19 && interval >= 8) {
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.method_10263() / 2, interval - 8, 2, 6, 0);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.method_10263() / 2, interval - 8, 2, 6, -3);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.method_10263() / 2, interval - 8, 2, 6, -6);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.method_10263() / 2, interval - 8, 2, 6, -9);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.method_10263() / 2, interval - 8, 2, 6, -12);
                EssenceBlockPurple.bars(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaSize.method_10263() / 2, interval - 8, 2, 6, -15);
            }
            if (interval < 28 && interval >= 20 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 2;
                    int miniZ = z / 2;
                    if (interval % 4 == 0) {
                        return miniX % 2 == 0;
                    }
                    return miniZ % 2 == 0;
                });
            }
            if (interval < 32 && interval >= 28 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x + z) % 6) < 2;
                    }
                    return Math.abs((x + z) % 6) >= 2;
                });
            }
            if (interval < 36 && interval >= 32 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x - z) % 6) < 2;
                    }
                    return Math.abs((x - z) % 6) >= 2;
                });
            }
            if (interval < 41 && interval >= 36 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    boolean crossLinked;
                    boolean bl = crossLinked = Math.abs((x - z) % 6) < 2 || Math.abs((x + z) % 6) < 2;
                    if (interval % 4 == 0) {
                        return crossLinked;
                    }
                    return !crossLinked;
                });
            }
            if (interval < 63 && interval >= 42) {
                intervalOffset = interval - 42;
                arenaRadiusSq = xRadius * xRadius + zRadius * zRadius;
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, 0, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -3, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -6, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -9, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -12, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -15, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -18, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -21, true);
                EssenceBlockPurple.ring(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, arenaRadiusSq, intervalOffset, -24, true);
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                    int outerRadius = arenaRadiusSq / 20;
                    int currentRadiusSq = x * x + z * z;
                    return currentRadiusSq < outerRadius + intervalOffset * 4;
                });
            }
            if (interval < 81 && interval >= 64) {
                intervalOffset = interval - 64;
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                    float newX = (float)x.intValue() * class_3532.method_15362((float)(intervalOffset * 5)) - (float)z.intValue() * class_3532.method_15374((float)(intervalOffset * 5));
                    float newZ = (float)x.intValue() * class_3532.method_15374((float)(intervalOffset * 5)) + (float)z.intValue() * class_3532.method_15362((float)(intervalOffset * 5));
                    float sinResult = class_3532.method_15374((float)(newX * newZ * ((float)Math.PI / 180)));
                    return (sinResult = Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult)) < 0.1f;
                });
                if (interval > 71 && interval % 5 == 0) {
                    EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                        int miniX = x / 2;
                        int miniZ = z / 2;
                        if (interval % 4 == 0) {
                            return miniX % 2 == 0;
                        }
                        return miniZ % 2 == 0;
                    });
                }
            }
            if (interval < 90 && interval >= 82 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 6;
                    int miniZ = z / 6;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval < 94 && interval >= 90 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 8;
                    int miniZ = z / 8;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval == 95) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, 72, 36, true, (x, z) -> {
                    float newX = (float)x.intValue() * class_3532.method_15362((float)0.0f) - (float)z.intValue() * class_3532.method_15374((float)0.0f);
                    float newZ = (float)x.intValue() * class_3532.method_15374((float)0.0f) + (float)z.intValue() * class_3532.method_15362((float)0.0f);
                    float sinResult = class_3532.method_15374((float)(-(newX * newZ) * ((float)Math.PI / 180)));
                    return (sinResult = Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult)) < 0.5f;
                });
            }
            if (interval < 105 && interval >= 97) {
                intervalOffset = interval - 95;
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, true, (x, z) -> {
                    float newX = (float)x.intValue() * class_3532.method_15362((float)(intervalOffset * 5)) - (float)z.intValue() * class_3532.method_15374((float)(intervalOffset * 5));
                    float newZ = (float)x.intValue() * class_3532.method_15374((float)(intervalOffset * 5)) + (float)z.intValue() * class_3532.method_15362((float)(intervalOffset * 5));
                    float sinResult = class_3532.method_15374((float)(-(newX * newZ) * ((float)Math.PI / 180)));
                    return (sinResult = Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult) * Math.abs(sinResult)) < 0.5f;
                });
            }
            if (interval < 110 && interval >= 106 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 2;
                    int miniZ = z / 2;
                    if (interval % 4 == 0) {
                        return miniX % 2 == 0;
                    }
                    return miniZ % 2 == 0;
                });
            }
            if (interval < 114 && interval >= 110 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x + z) % 6) < 4;
                    }
                    return Math.abs((x + z) % 6) >= 4;
                });
            }
            if (interval < 118 && interval >= 114 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x - z) % 6) < 4;
                    }
                    return Math.abs((x - z) % 6) >= 4;
                });
            }
            if (interval < 122 && interval >= 118 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 3;
                    int miniZ = z / 3;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval < 128 && interval >= 122 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    int miniX = x / 2;
                    int miniZ = z / 2;
                    if (interval % 4 == 0) {
                        return Math.abs((miniX + miniZ) % 2) == 0;
                    }
                    return Math.abs((miniX + miniZ) % 2) == 1;
                });
            }
            if (interval < 132 && interval >= 128 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return x % 2 == 0;
                    }
                    return z % 2 == 0;
                });
            }
            if (interval >= 132 && interval % 2 == 0) {
                EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
                    if (interval % 4 == 0) {
                        return Math.abs((x + z) % 2) == 0;
                    }
                    return Math.abs((x + z) % 2) == 1;
                });
            }
        }
    }

    private static void bars(class_3218 serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, int arenaRadius, int interval, int height, int width, int offset) {
        EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, false, (x, z) -> {
            int barTop = arenaRadius - (interval + offset) * height;
            int barBottom = arenaRadius - height - (interval + offset) * height;
            if (Math.abs(x) <= barTop && Math.abs(x) > barBottom) {
                if (interval % 2 == 0) {
                    if (z < 0) {
                        return z % (width * 2) >= -width;
                    }
                    return z % (width * 2) >= width;
                }
                if (z < 0) {
                    return z % (width * 2) < -width;
                }
                return z % (width * 2) < width;
            }
            return false;
        });
    }

    private static void ring(class_3218 serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, int arenaRadiusSq, int intervalOffset, int delay, boolean addToExistingSpike) {
        EssenceBlockPurple.patternFunction(serverLevel, essenceBlockEntity, eventEntitiesInArena, xRadius, zRadius, addToExistingSpike, (x, z) -> {
            int innerRadius = arenaRadiusSq / 20 * (intervalOffset + delay) * (intervalOffset + delay);
            int outerRadius = arenaRadiusSq / 20 * (intervalOffset + delay + 1) * (intervalOffset + delay + 1);
            if (intervalOffset % 2 == 0 ? (double)Math.abs(x) <= Math.sqrt(outerRadius) / 3.0 : (double)Math.abs(z) <= Math.sqrt(outerRadius) / 3.0) {
                return false;
            }
            int currentRadiusSq = x * x + z * z;
            return currentRadiusSq >= innerRadius && currentRadiusSq < outerRadius;
        });
    }

    private static void patternFunction(class_3218 serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, boolean addToExistingSpike, BiPredicate<Integer, Integer> patternCondition) {
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                if (!patternCondition.test(x, z)) continue;
                EssenceBlockPurple.activateSpike(serverLevel, x, z, 36, 36, essenceBlockEntity, eventEntitiesInArena, addToExistingSpike);
            }
        }
    }

    private static void patternFunction(class_3218 serverLevel, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, int xRadius, int zRadius, int chargeTime, int spikeTime, boolean addToExistingSpike, BiPredicate<Integer, Integer> patternCondition) {
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                if (!patternCondition.test(x, z)) continue;
                EssenceBlockPurple.activateSpike(serverLevel, x, z, chargeTime, spikeTime, essenceBlockEntity, eventEntitiesInArena, addToExistingSpike);
            }
        }
    }

    private static void activateSpike(class_3218 serverLevel, int x, int z, int chargeTime, int spikeTime, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena, boolean addToExistingSpike) {
        class_2338 arenaSize = essenceBlockEntity.getArenaSize();
        int rowLength = arenaSize.method_10263() - 2;
        int columnLength = arenaSize.method_10260() - 2;
        int newX = x + rowLength / 2;
        int newZ = z + columnLength / 2;
        if (newX > rowLength || newZ > columnLength || newX + newZ * columnLength >= eventEntitiesInArena.size()) {
            Bumblezone.LOGGER.warn("Bumblezone: Detected invalid {} {} ({} {}) coordinate for trying to activate a spike. Grid size {} and row length {} - column length {}", new Object[]{x, z, newX, newZ, eventEntitiesInArena.size(), rowLength, columnLength});
        } else {
            EssenceBlockEntity.EventEntities eventEntities = eventEntitiesInArena.get(newX + newZ * columnLength);
            class_1297 entity = serverLevel.method_14190(eventEntities.uuid());
            if (entity instanceof PurpleSpikeEntity) {
                PurpleSpikeEntity purpleSpikeEntity = (PurpleSpikeEntity)entity;
                if (addToExistingSpike && !purpleSpikeEntity.hasSpikeCharge() && purpleSpikeEntity.hasSpike()) {
                    purpleSpikeEntity.setSpikeChargeTimer(0);
                    purpleSpikeEntity.setSpikeTimer(spikeTime + chargeTime);
                } else {
                    purpleSpikeEntity.setSpikeChargeTimer(chargeTime);
                    purpleSpikeEntity.setSpikeTimer(spikeTime);
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.KNOWING_EVENT.get().method_14833(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.KNOWING_EVENT.get().method_14833(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

