/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1463;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3730;
import net.minecraft.class_4970;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EssenceBlockRed
extends EssenceBlock {
    private static final float ENTITIES_TO_KILL = 100.0f;

    public EssenceBlockRed() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16020));
    }

    @Override
    public class_2960 getArenaNbt() {
        return new class_2960("the_bumblezone", "essence/red_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 8000;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.red_essence_event", class_1259.class_1260.field_5784, class_1259.class_1261.field_5790).method_5406(true);
    }

    @Override
    public class_1799 getEssenceItemReward() {
        return BzItems.ESSENCE_RAGING.get().method_7854();
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(class_3222 serverPlayer) {
        serverPlayer.method_7281(BzStats.RAGING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        int entitiesKilled = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if ((float)entitiesKilled != 100.0f && (double)eventEntitiesInArena.size() < Math.min(3.0 + (double)essenceBlockEntity.getPlayerInArena().size() * 1.5, (double)(100.0f - (float)entitiesKilled))) {
            int currentEntityCount = eventEntitiesInArena.size() + entitiesKilled;
            EssenceBlockRed.SpawnNewEnemy(serverLevel, blockPos, essenceBlockEntity, currentEntityCount, eventEntitiesInArena);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                class_1308 mob;
                class_5354 neutralMob;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                class_1297 entity = serverLevel.method_14190(entityToCheck);
                if (entity == null) {
                    ++entitiesKilled;
                    eventEntitiesInArena.remove(i);
                    continue;
                }
                if (entity instanceof class_5354 && !((neutralMob = (class_5354)entity).method_5968() instanceof class_1657)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.method_8409().method_43048(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.method_18470(playerUUID);
                    neutralMob.method_29514(Integer.MAX_VALUE);
                    neutralMob.method_29513(playerUUID);
                    neutralMob.method_5980((class_1309)player);
                } else if (entity instanceof class_1308 && !((mob = (class_1308)entity).method_5968() instanceof class_1657)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.method_8409().method_43048(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.method_18470(playerUUID);
                    mob.method_5980((class_1309)player);
                }
                if (Math.abs(entity.method_24515().method_10263() - blockPos.method_10263()) <= essenceBlockEntity.getArenaSize().method_10263() / 2 && Math.abs(entity.method_24515().method_10264() - blockPos.method_10264()) <= essenceBlockEntity.getArenaSize().method_10264() / 2 && Math.abs(entity.method_24515().method_10260() - blockPos.method_10260()) <= essenceBlockEntity.getArenaSize().method_10260() / 2) continue;
                int yOffset = -essenceBlockEntity.getArenaSize().method_10264() / 2 + 2;
                class_2338 center = blockPos.method_10069(0, yOffset, 0);
                entity.method_24203((double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260());
            }
        }
        float newProgress = (float)entitiesKilled / 100.0f;
        essenceBlockEntity.getEventBar().method_5408(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(entitiesKilled);
        if ((float)entitiesKilled == 100.0f) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void SpawnNewEnemy(class_3218 serverLevel, class_2338 blockPos, EssenceBlockEntity essenceBlockEntity, int currentEntityCount, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        class_6862<class_1299<?>> enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_NORMAL_ENEMY;
        int entityToSpawnIndex = currentEntityCount + 1;
        if (entityToSpawnIndex % 25 == 0 || entityToSpawnIndex == 49 || entityToSpawnIndex == 73 || entityToSpawnIndex == 74 || entityToSpawnIndex == 97 || entityToSpawnIndex == 98 || entityToSpawnIndex == 99) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_BOSS_ENEMY;
        } else if (entityToSpawnIndex % 5 == 0) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_STRONG_ENEMY;
        } else if (entityToSpawnIndex % 3 == 0) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_RANGED_ENEMY;
        }
        List entityTypeList = class_7923.field_41177.method_40266(enemyTagToUse).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElseGet(ArrayList::new);
        class_1299 entityTypeToSpawn = (class_1299)entityTypeList.get(serverLevel.method_8409().method_43048(entityTypeList.size()));
        int yOffset = -essenceBlockEntity.getArenaSize().method_10264() / 2 + 2;
        class_1297 entity = entityTypeToSpawn.method_47821(serverLevel, blockPos.method_10069(0, yOffset, 0), class_3730.field_16461);
        if (entity != null) {
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.method_5667()));
            UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.method_8409().method_43048(essenceBlockEntity.getPlayerInArena().size()));
            class_3222 player = serverLevel.method_8503().method_3760().method_14602(playerUUID);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = player;
                float maxHeart = Math.max(serverPlayer.method_6032(), serverPlayer.method_6063());
                float maxArmor = serverPlayer.method_6096();
                float mobHealthBoost = maxHeart / 15.0f + maxArmor / 10.0f;
                float mobAttackBoost = maxHeart / 20.0f + maxArmor / 15.0f;
                boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
                if (!isEssenced) {
                    mobHealthBoost *= 1.5f;
                    mobAttackBoost *= 1.5f;
                }
                if (entity instanceof class_1309) {
                    class_1324 livingEntityAttributeFollowRange;
                    class_1324 livingEntityAttributeFlyingSpeed;
                    class_1324 livingEntityAttributeSpeed;
                    class_1324 livingEntityAttributeAttack;
                    class_1309 livingEntity = (class_1309)entity;
                    class_1324 livingEntityAttributeHealth = livingEntity.method_5996(class_5134.field_23716);
                    if (livingEntityAttributeHealth != null) {
                        livingEntityAttributeHealth.method_26837(new class_1322(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)mobHealthBoost, class_1322.class_1323.field_6328));
                        livingEntity.method_6025(mobHealthBoost);
                    }
                    if ((livingEntityAttributeAttack = livingEntity.method_5996(class_5134.field_23721)) != null) {
                        livingEntityAttributeAttack.method_26837(new class_1322(UUID.fromString("355141f8-09eb-11ee-be56-0242ac120002"), "Essence Arena Damage Boost", (double)mobAttackBoost, class_1322.class_1323.field_6328));
                    }
                    if ((livingEntityAttributeSpeed = livingEntity.method_5996(class_5134.field_23719)) != null) {
                        livingEntityAttributeSpeed.method_26837(new class_1322(UUID.fromString("39ca0496-fa37-488f-8199-c4779f1afe0c"), "Essence Arena Speed Boost", isEssenced ? 0.05 : 0.065, class_1322.class_1323.field_6328));
                    }
                    if ((livingEntityAttributeFlyingSpeed = livingEntity.method_5996(class_5134.field_23720)) != null) {
                        livingEntityAttributeFlyingSpeed.method_26837(new class_1322(UUID.fromString("c762c216-0a3a-11ee-be56-0242ac120002"), "Essence Arena Flying Speed Boost", 0.065, class_1322.class_1323.field_6328));
                    }
                    if ((livingEntityAttributeFollowRange = livingEntity.method_5996(class_5134.field_23717)) != null) {
                        livingEntityAttributeFollowRange.method_26837(new class_1322(UUID.fromString("23a7a8a9-85bc-4dc3-9417-a4bd4b1b95a2"), "Essence Arena Sight Boost", 32.0, class_1322.class_1323.field_6328));
                    }
                }
                if (entity instanceof class_5354) {
                    class_5354 neutralMob = (class_5354)entity;
                    neutralMob.method_29514(Integer.MAX_VALUE);
                    neutralMob.method_29513(playerUUID);
                    neutralMob.method_5980((class_1309)serverPlayer);
                } else if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    mob.method_5980((class_1309)serverPlayer);
                    if (entity instanceof class_1463) {
                        class_1463 rabbit = (class_1463)entity;
                        rabbit.method_47853(class_1463.class_7990.field_41567);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.RADIANCE_EVENT.get().method_14833(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.RADIANCE_EVENT.get().method_14833(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

