/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.CooldownInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.ItemCooldownsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class AbilityEssenceItem
extends class_1792
implements ItemExtension {
    private static final String IS_IN_INVENTORY_TAG = "isInInventory";
    private static final String ACTIVE_TAG = "isActive";
    private static final String LOCKED_TAG = "isLocked";
    private static final String COOLDOWN_TIME_TAG = "cooldownTime";
    private static final String FORCED_COOLDOWN_TAG = "forcedCooldown";
    private static final String LAST_ABILITY_CHARGE_TIMESTAMP_TAG = "lastChargeTime";
    private static final String ABILITY_USE_REMAINING_TAG = "abilityUseRemaining";
    private final Supplier<Integer> cooldownTickLength;
    private final Supplier<Integer> abilityUseAmount;

    public AbilityEssenceItem(class_1792.class_1793 properties, Supplier<Integer> cooldownTickLength, Supplier<Integer> abilityUseAmount) {
        super(properties);
        this.cooldownTickLength = cooldownTickLength;
        this.abilityUseAmount = abilityUseAmount;
    }

    public abstract int getColor();

    public int getCooldownTickLength() {
        return this.cooldownTickLength.get();
    }

    public static void setLastAbilityChargeTimestamp(class_1799 stack, int gametime) {
        stack.method_7948().method_10569(LAST_ABILITY_CHARGE_TIMESTAMP_TAG, gametime);
    }

    public static int getLastAbilityChargeTimestamp(class_1799 stack) {
        return stack.method_7948().method_10550(LAST_ABILITY_CHARGE_TIMESTAMP_TAG);
    }

    public static void setIsActive(class_1799 stack, boolean isActive) {
        stack.method_7948().method_10556(ACTIVE_TAG, isActive);
    }

    public static boolean getIsActive(class_1799 stack) {
        return stack.method_7948().method_10577(ACTIVE_TAG);
    }

    public static void setIsInInventory(class_1799 stack, boolean isInInventory) {
        stack.method_7948().method_10556(IS_IN_INVENTORY_TAG, isInInventory);
    }

    public static boolean getIsInInventory(class_1799 stack) {
        return stack.method_7948().method_10577(IS_IN_INVENTORY_TAG);
    }

    public static void setIsLocked(class_1799 stack, boolean isLocked) {
        stack.method_7948().method_10556(LOCKED_TAG, isLocked);
    }

    public static boolean getIsLocked(class_1799 stack) {
        return stack.method_7948().method_10577(LOCKED_TAG);
    }

    public static void setForcedCooldown(class_1799 stack, boolean forcedCooldown) {
        stack.method_7948().method_10556(FORCED_COOLDOWN_TAG, forcedCooldown);
    }

    public static boolean getForcedCooldown(class_1799 stack) {
        return stack.method_7948().method_10577(FORCED_COOLDOWN_TAG);
    }

    public static void setCooldownTime(class_1799 stack, int cooldownTime) {
        stack.method_7948().method_10569(COOLDOWN_TIME_TAG, cooldownTime);
    }

    public static int getCooldownTime(class_1799 stack) {
        return stack.method_7948().method_10550(COOLDOWN_TIME_TAG);
    }

    public void incrementCooldownTime(class_1799 stack) {
        if (AbilityEssenceItem.getForcedCooldown(stack)) {
            int currentCooldownTime = AbilityEssenceItem.getCooldownTime(stack);
            if (currentCooldownTime < this.cooldownTickLength.get()) {
                AbilityEssenceItem.setCooldownTime(stack, currentCooldownTime + 1);
            } else {
                AbilityEssenceItem.setCooldownTime(stack, 0);
                AbilityEssenceItem.setForcedCooldown(stack, false);
                this.rechargeAbilityEntirely(stack);
            }
        }
    }

    public void setDepleted(class_1799 stack, class_3222 serverPlayer, boolean vanillaItemCooldown) {
        AbilityEssenceItem.setForcedCooldown(stack, true);
        AbilityEssenceItem.setCooldownTime(stack, 0);
        AbilityEssenceItem.setIsActive(stack, false);
        if (vanillaItemCooldown) {
            serverPlayer.method_7357().method_7906((class_1792)this, this.getCooldownTickLength());
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int i, boolean bl) {
        if (stack.method_31573(BzTags.ABILITY_ESSENCE_ITEMS) && entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            if (!AbilityEssenceItem.getIsInInventory(stack)) {
                AbilityEssenceItem.setIsInInventory(stack, true);
            }
            if (!EssenceOfTheBees.hasEssence(serverPlayer)) {
                AbilityEssenceItem.setIsActive(stack, false);
                AbilityEssenceItem.setIsLocked(stack, true);
                return;
            }
            if (AbilityEssenceItem.getIsLocked(stack)) {
                AbilityEssenceItem.setIsLocked(stack, false);
            }
            if (AbilityEssenceItem.getForcedCooldown(stack)) {
                this.incrementCooldownTime(stack);
                if (!serverPlayer.method_7357().method_7904(stack.method_7909())) {
                    serverPlayer.method_7357().method_7906(stack.method_7909(), this.getCooldownTickLength() - AbilityEssenceItem.getCooldownTime(stack));
                }
            } else if (serverPlayer.method_7357().method_7904(stack.method_7909())) {
                class_1796.class_1797 cooldownInstance = ((ItemCooldownsAccessor)serverPlayer.method_7357()).getCooldowns().get(stack.method_7909());
                int cooldownTime = ((ItemCooldownsAccessor)serverPlayer.method_7357()).getTickCount() - ((CooldownInstanceAccessor)cooldownInstance).getStartTime();
                AbilityEssenceItem.setForcedCooldown(stack, true);
                AbilityEssenceItem.setCooldownTime(stack, cooldownTime);
                AbilityEssenceItem.setIsActive(stack, false);
            } else if (serverPlayer.method_6079() == stack) {
                if (!AbilityEssenceItem.getIsActive(stack)) {
                    AbilityEssenceItem.setIsActive(stack, true);
                }
                this.applyAbilityEffects(stack, level, serverPlayer);
            } else {
                this.rechargeAbilitySlowly(stack, level, serverPlayer);
                if (AbilityEssenceItem.getIsActive(stack)) {
                    AbilityEssenceItem.setIsActive(stack, false);
                }
            }
        }
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> components, class_1836 tooltipFlag) {
        if (AbilityEssenceItem.getIsLocked(stack)) {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_locked").method_27692(class_124.field_1079));
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_locked_description_1").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_locked_description_2").method_27692(class_124.field_1080));
        } else if (AbilityEssenceItem.getIsActive(stack)) {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_active").method_27692(class_124.field_1061));
            components.add((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(stack), this.getMaxAbilityUseAmount()}).method_27692(class_124.field_1054));
            components.add((class_2561)class_2561.method_43473());
            this.addDescriptionComponents(components);
        } else if (AbilityEssenceItem.getForcedCooldown(stack)) {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_depleted").method_27692(class_124.field_1079));
            components.add((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_cooldown", (Object[])new Object[]{GeneralUtils.formatTickDurationNoMilliseconds(this.getCooldownTickLength() - AbilityEssenceItem.getCooldownTime(stack), 1.0f)}).method_27692(class_124.field_1079));
            components.add((class_2561)class_2561.method_43473());
            this.addDescriptionComponents(components);
        } else {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_ready").method_27692(class_124.field_1060));
            components.add((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(stack), this.getMaxAbilityUseAmount()}).method_27692(class_124.field_1054));
            components.add((class_2561)class_2561.method_43473());
            this.addDescriptionComponents(components);
        }
    }

    abstract void addDescriptionComponents(List<class_2561> var1);

    abstract void applyAbilityEffects(class_1799 var1, class_1937 var2, class_3222 var3);

    public int getAbilityUseRemaining(class_1799 stack) {
        if (!stack.method_7948().method_10545(ABILITY_USE_REMAINING_TAG)) {
            this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
            return this.getMaxAbilityUseAmount();
        }
        return stack.method_7948().method_10550(ABILITY_USE_REMAINING_TAG);
    }

    public int getMaxAbilityUseAmount() {
        return this.abilityUseAmount.get();
    }

    public void setAbilityUseRemaining(class_1799 stack, int abilityUseRemaining) {
        stack.method_7948().method_10569(ABILITY_USE_REMAINING_TAG, abilityUseRemaining);
    }

    public void rechargeAbilityEntirely(class_1799 stack) {
        this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
    }

    public void rechargeAbilitySlowly(class_1799 stack, class_1937 level, class_3222 serverPlayer) {
        int abilityUseRemaining = this.getAbilityUseRemaining(stack);
        if (abilityUseRemaining < this.getMaxAbilityUseAmount()) {
            int lastChargeTime = AbilityEssenceItem.getLastAbilityChargeTimestamp(stack);
            if (lastChargeTime == 0 || serverPlayer.field_6012 < lastChargeTime) {
                AbilityEssenceItem.setLastAbilityChargeTimestamp(stack, serverPlayer.field_6012);
            } else {
                int timeFromLastCharge = serverPlayer.field_6012 - lastChargeTime;
                int chargeTimeIncrement = Math.max(this.getCooldownTickLength() / this.getMaxAbilityUseAmount(), 1);
                if (timeFromLastCharge % chargeTimeIncrement == 0) {
                    this.setAbilityUseRemaining(stack, abilityUseRemaining + 1);
                    AbilityEssenceItem.setLastAbilityChargeTimestamp(stack, serverPlayer.field_6012);
                }
            }
        }
    }

    @Override
    public class_1304 bz$getEquipmentSlot(class_1799 stack) {
        return class_1304.field_6171;
    }

    @Nullable
    public class_1304 getEquipmentSlot(class_1799 stack) {
        return this.bz$getEquipmentSlot(stack);
    }

    public boolean method_31567(class_1799 itemStack) {
        int remainingUse = this.getAbilityUseRemaining(itemStack);
        return remainingUse != 0 && this.getMaxAbilityUseAmount() != remainingUse;
    }

    public int method_31569(class_1799 itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        return Math.round(remainingUse / maxAmount * 13.0f);
    }

    public int method_31571(class_1799 itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        float redValue = Math.max(0.0f, remainingUse / maxAmount);
        return class_3532.method_15369((float)(redValue / 3.0f), (float)1.0f, (float)1.0f);
    }
}

