/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.TwoToneSpikeFeatureConfig;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3195;
import net.minecraft.class_3233;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public class TwoToneSpikeFeature
extends class_3031<TwoToneSpikeFeatureConfig> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public TwoToneSpikeFeature(Codec<TwoToneSpikeFeatureConfig> configFactory) {
        super(configFactory);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public boolean method_13151(class_5821<TwoToneSpikeFeatureConfig> context) {
        class_2680 state;
        this.setSeed(context.method_33652().method_8412());
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339();
        class_5281 level = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 origin = context.method_33655();
        if (level.method_8320(origin).method_26225()) {
            return false;
        }
        class_2378 structureRegistry = (class_2378)context.method_33652().method_30349().method_33310(class_7924.field_41246).get();
        if (context.method_33652() instanceof class_3233) {
            class_3195 thronePillar;
            class_5138 structureManager = ((WorldGenRegionAccessor)context.method_33652()).getStructureManager();
            if (origin.method_10264() > 130 && origin.method_10264() < 148 && (thronePillar = (class_3195)structureRegistry.method_10223(new class_2960("the_bumblezone", "throne_pillar"))) != null && structureManager.method_28388(origin, thronePillar).method_16657()) {
                return false;
            }
            Optional optionalHolders = structureRegistry.method_40266(BzTags.NO_GIANT_SPIKES);
            if (optionalHolders.isPresent()) {
                for (class_6880 structureHolder : (class_6885.class_6888)optionalHolders.get()) {
                    if (!structureManager.method_28388(origin, (class_3195)structureHolder.comp_349()).method_16657()) continue;
                    return false;
                }
            }
        }
        boolean validSpot = false;
        boolean superSlant = false;
        Object wallDirection = null;
        class_2680 attachedState = null;
        for (class_2350 direction : class_2350.class_2353.field_11064) {
            blockpos$Mutable.method_10101((class_2382)origin).method_10104(direction, 5);
            state = level.method_8320((class_2338)blockpos$Mutable);
            if (!state.method_26225()) continue;
            validSpot = true;
            attachedState = state;
            break;
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            blockpos$Mutable.method_10101((class_2382)origin).method_10104(direction, 1);
            state = level.method_8320((class_2338)blockpos$Mutable);
            if (!state.method_26225()) continue;
            validSpot = true;
            attachedState = state;
        }
        if (!validSpot) {
            return false;
        }
        if (!attachedState.method_26164(((TwoToneSpikeFeatureConfig)context.method_33656()).allowedBaseBlockCopies)) {
            return false;
        }
        blockpos$Mutable.method_10101((class_2382)origin).method_10104(class_2350.field_11036, 5);
        int directionSign = level.method_8320((class_2338)blockpos$Mutable).method_26225() ? -1 : 1;
        int currentY = origin.method_10264() - directionSign * 5;
        int thickness = random.method_43048(3) + 4;
        int height = ((TwoToneSpikeFeatureConfig)context.method_33656()).heightRange.method_35008(context.method_33654());
        int slantAmountX = (random.method_43048(6) + 5) * (random.method_43056() ? -1 : 1);
        int slantAmountZ = (random.method_43048(6) + 5) * (random.method_43056() ? -1 : 1);
        if (random.method_43048(4) == 0) {
            slantAmountX = 0;
        }
        if (random.method_43048(4) == 0) {
            slantAmountZ = 0;
        }
        class_2680 tipBlock = ((TwoToneSpikeFeatureConfig)context.method_33656()).tipBlocks.get(context.method_33654().method_43048(((TwoToneSpikeFeatureConfig)context.method_33656()).tipBlocks.size())).method_9564();
        for (int layer = 0; layer < height; ++layer) {
            int currentZSlant;
            float currentThickness = thickness;
            int currentXSlant = slantAmountX == 0 ? 0 : layer / slantAmountX;
            int n = currentZSlant = slantAmountZ == 0 ? 0 : layer / slantAmountZ;
            if (layer == 0) {
                currentThickness -= 2.0f;
            } else if (layer == 1) {
                currentThickness -= 1.0f;
            } else if (layer == height - 1) {
                currentThickness = 0.5f;
                currentXSlant = slantAmountX == 0 ? 0 : (layer - 1) / slantAmountX;
                currentZSlant = slantAmountZ == 0 ? 0 : (layer - 1) / slantAmountZ;
            } else {
                currentThickness *= Math.max((float)(height - layer) / (float)height, 0.2f);
                currentThickness = Math.max(currentThickness, 1.1f);
            }
            int x = (int)(-currentThickness);
            while ((float)x <= currentThickness) {
                int z = (int)(-currentThickness);
                while ((float)z <= currentThickness) {
                    if ((float)(x * x + z * z) < currentThickness * currentThickness) {
                        blockpos$Mutable.method_10103(origin.method_10263() + x + currentXSlant, currentY, origin.method_10260() + z + currentZSlant);
                        class_2680 state2 = level.method_8320((class_2338)blockpos$Mutable);
                        if (!state2.method_26225() && !state2.method_27852(BzBlocks.CRYSTALLINE_FLOWER.get())) {
                            class_2680 newState = (double)layer > (double)((float)(height * 2) / 3.0f) + noiseGen.noise3_Classic(blockpos$Mutable.method_10263(), blockpos$Mutable.method_10264(), blockpos$Mutable.method_10260()) * 2.0 ? tipBlock : attachedState;
                            level.method_8652((class_2338)blockpos$Mutable, newState, 3);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            currentY += directionSign;
        }
        return false;
    }
}

