/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyWeb;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFeatures;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_5821;

public class WebWall
extends class_3031<class_3111> {
    public static final Map<class_2350.class_2351, Set<class_2350>> AXIS_TO_FACINGS = ImmutableMap.copyOf((Map)((Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class_2351.class), map -> {
        map.put(class_2350.class_2351.field_11048, ImmutableSet.of((Object)class_2350.field_11043, (Object)class_2350.field_11035, (Object)class_2350.field_11036, (Object)class_2350.field_11033));
        map.put(class_2350.class_2351.field_11051, ImmutableSet.of((Object)class_2350.field_11034, (Object)class_2350.field_11039, (Object)class_2350.field_11036, (Object)class_2350.field_11033));
        map.put(class_2350.class_2351.field_11052, ImmutableSet.of((Object)class_2350.field_11034, (Object)class_2350.field_11039, (Object)class_2350.field_11043, (Object)class_2350.field_11035));
    })));

    public WebWall(Codec<class_3111> configFactory) {
        super(configFactory);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_2338 blockPos = new class_1923(context.method_33655()).method_33943(context.method_33655().method_10264());
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((class_1936)context.method_33652());
        if (bulkSectionAccess.getBlockState(blockPos).method_27852(class_2246.field_10543)) {
            for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
                HashSet<class_2338> validSpaces = new HashSet<class_2338>();
                validSpaces.add(blockPos);
                boolean isInBounds = this.setIfValidSpace(bulkSectionAccess, axis, blockPos, blockPos, validSpaces);
                if (!isInBounds) continue;
                for (class_2338 validPos : validSpaces) {
                    for (int attempt = 0; attempt < 12; ++attempt) {
                        BzFeatures.STICKY_HONEY_RESIDUE_FEATURE.get().method_13151(new class_5821(context.method_38427(), context.method_33652(), context.method_33653(), context.method_33654(), validPos.method_10069(context.method_33654().method_43048(9) - 4, context.method_33654().method_43048(9) - 4, context.method_33654().method_43048(9) - 4), (class_3037)((class_3111)context.method_33656())));
                    }
                    class_2680 state = bulkSectionAccess.getBlockState(validPos);
                    if (state.method_27852(BzBlocks.HONEY_WEB.get())) {
                        bulkSectionAccess.setBlockState(validPos, (class_2680)state.method_11657((class_2769)HoneyWeb.AXIS_TO_PROP.get(axis), (Comparable)Boolean.valueOf(true)), false);
                        continue;
                    }
                    bulkSectionAccess.setBlockState(validPos, (class_2680)BzBlocks.HONEY_WEB.get().method_9564().method_11657((class_2769)HoneyWeb.AXIS_TO_PROP.get(axis), (Comparable)Boolean.valueOf(true)), false);
                }
                return true;
            }
        }
        return false;
    }

    private boolean setIfValidSpace(UnsafeBulkSectionAccess bulkSectionAccess, class_2350.class_2351 axis, class_2338 originPos, class_2338 currentPos, Set<class_2338> validSpaces) {
        int maxDistance = 14;
        for (class_2350 direction : AXIS_TO_FACINGS.get(axis)) {
            class_2338 newBlockPos = currentPos.method_10093(direction);
            if (Math.abs(newBlockPos.method_10263() - originPos.method_10263()) > maxDistance || Math.abs(newBlockPos.method_10264() - originPos.method_10264()) > maxDistance || Math.abs(newBlockPos.method_10260() - originPos.method_10260()) > maxDistance) {
                return false;
            }
            if (validSpaces.contains(newBlockPos)) continue;
            class_2680 state = bulkSectionAccess.getBlockState(newBlockPos);
            if (state.method_26215() || state.method_27852(BzBlocks.PILE_OF_POLLEN.get()) || state.method_27852(BzBlocks.HONEY_WEB.get())) {
                validSpaces.add(newBlockPos);
                if (this.setIfValidSpace(bulkSectionAccess, axis, originPos, newBlockPos, validSpaces)) continue;
                return false;
            }
            if (!state.method_27852(BzBlocks.HONEY_WEB.get())) continue;
            validSpaces.add(newBlockPos);
        }
        return true;
    }
}

