/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities.renders;

import com.finallion.graveyard.blockentities.GravestoneBlockEntity;
import com.finallion.graveyard.blocks.GravestoneBlock;
import com.finallion.graveyard.init.TGBlocks;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_837;

@Environment(value=EnvType.CLIENT)
public class GravestoneBlockEntityRenderer
implements class_827<GravestoneBlockEntity> {
    private static final int RENDER_DISTANCE = class_3532.method_34954((int)16);
    private final class_327 textRenderer;
    private static final HashMap<class_2248, class_1921> LAYERS = Maps.newHashMap();
    private static class_1921 defaultLayer = class_1921.method_23572((class_2960)new class_2960("textures/entity/signs/oak.png"));

    public GravestoneBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
    }

    public void render(GravestoneBlockEntity signBlockEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, int j) {
        int r;
        boolean bl2;
        int q;
        class_2680 blockState = signBlockEntity.method_11010();
        class_1937 world = signBlockEntity.method_10997();
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.25, 0.5);
        float rotation = -((class_2350)blockState.method_11654((class_2769)GravestoneBlock.FACING)).method_10144();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        matrixStack.method_22903();
        matrixStack.method_22905(0.6666667f, -0.6666667f, -0.6666667f);
        matrixStack.method_22909();
        matrixStack.method_22904(0.0, 0.3333333432674408, 0.23);
        matrixStack.method_22905(0.010416667f, -0.010416667f, 0.010416667f);
        int m = GravestoneBlockEntityRenderer.getColor(signBlockEntity);
        class_5481[] orderedTexts = signBlockEntity.getText().method_49868(class_310.method_1551().method_33883(), text -> {
            List list = this.textRenderer.method_1728((class_5348)text, signBlockEntity.getMaxTextWidth());
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (signBlockEntity.getText().method_49856()) {
            q = signBlockEntity.getText().method_49872().method_16357();
            bl2 = GravestoneBlockEntityRenderer.shouldRender(signBlockEntity, q);
            r = 0xF000F0;
        } else {
            q = m;
            bl2 = false;
            r = i;
        }
        for (int s = 0; s < 4; ++s) {
            class_5481 orderedText = orderedTexts[s];
            float t = -this.textRenderer.method_30880(orderedText) / 2;
            if (bl2) {
                this.textRenderer.method_37296(orderedText, t, (float)(s * 10 - 20), q, m, matrixStack.method_23760().method_23761(), vertexConsumerProvider, r);
                continue;
            }
            this.textRenderer.method_22942(orderedText, t, (float)(s * 10 - 20), q, false, matrixStack.method_23760().method_23761(), vertexConsumerProvider, class_327.class_6415.field_33993, 0, r);
        }
        matrixStack.method_22909();
        this.renderGrave(blockState, f, matrixStack, vertexConsumerProvider, i, j, world);
    }

    public void renderGrave(class_2680 state, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, int j, class_1937 world) {
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.43, 0.5);
        matrixStack.method_22905(2.28f, 2.15f, 2.28f);
        float rotation = ((class_2350)state.method_11654((class_2769)GravestoneBlock.FACING)).method_10144();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        class_310.method_1551().method_1480().method_23178(new class_1799((class_1935)state.method_26204().method_8389(), 1), class_811.field_4318, i, j, matrixStack, vertexConsumerProvider, world, 2);
        matrixStack.method_22909();
    }

    private static boolean shouldRender(GravestoneBlockEntity sign, int signColor) {
        if (signColor == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraftClient = class_310.method_1551();
        class_746 clientPlayerEntity = minecraftClient.field_1724;
        if (clientPlayerEntity != null && minecraftClient.field_1690.method_31044().method_31034() && clientPlayerEntity.method_31550()) {
            return true;
        }
        class_1297 entity = minecraftClient.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)sign.method_11016())) < (double)RENDER_DISTANCE;
    }

    static int getColor(GravestoneBlockEntity sign) {
        int i = sign.getText().method_49872().method_16357();
        if (i == class_1767.field_7963.method_16357() && sign.getText().method_49856()) {
            return -988212;
        }
        double d = 0.4;
        int j = (int)((double)class_5253.class_5254.method_27765((int)i) * d);
        int k = (int)((double)class_5253.class_5254.method_27766((int)i) * d);
        int l = (int)((double)class_5253.class_5254.method_27767((int)i) * d);
        return class_5253.class_5254.method_27764((int)0, (int)j, (int)k, (int)l);
    }

    public static class_837.class_4702 createSignModel(class_5599 entityModelLoader, class_4719 type) {
        return new class_837.class_4702(entityModelLoader.method_32072(class_5602.method_32078((class_4719)type)));
    }

    public static class_4588 getConsumer(class_4597 provider, class_2248 block) {
        return provider.getBuffer(LAYERS.getOrDefault(block, defaultLayer));
    }

    static {
        class_1921 layer1 = class_1921.method_23572((class_2960)TGBlocks.POLISHED_BASALT_GRAVESTONE_TEXTURE);
        class_1921 layer2 = class_1921.method_23572((class_2960)TGBlocks.COBBLESTONE_GRAVESTONE_TEXTURE);
        class_1921 layer3 = class_1921.method_23572((class_2960)TGBlocks.MOSSY_COBBLESTONE_GRAVESTONE_TEXTURE);
        class_1921 layer4 = class_1921.method_23572((class_2960)TGBlocks.DEEPSLATE_GRAVESTONE_TEXTURE);
        class_1921 layer5 = class_1921.method_23572((class_2960)TGBlocks.BLACKSTONE_GRAVESTONE_TEXTURE);
        class_1921 layer6 = class_1921.method_23572((class_2960)TGBlocks.CRACKED_BLACKSTONE_GRAVESTONE_TEXTURE);
        class_1921 layer7 = class_1921.method_23572((class_2960)TGBlocks.STONE_BRICKS_GRAVESTONE_TEXTURE);
        class_1921 layer8 = class_1921.method_23572((class_2960)TGBlocks.MOSSY_STONE_BRICKS_GRAVESTONE_TEXTURE);
        class_1921 layer9 = class_1921.method_23572((class_2960)TGBlocks.BRICKS_GRAVESTONE_TEXTURE);
        class_1921 layer10 = class_1921.method_23572((class_2960)TGBlocks.RED_SANDSTONE_GRAVESTONE_TEXTURE);
        class_1921 layer11 = class_1921.method_23572((class_2960)TGBlocks.SANDSTONE_GRAVESTONE_TEXTURE);
        class_1921 layer12 = class_1921.method_23572((class_2960)TGBlocks.GILDED_BLACKSTONE_GRAVESTONE_TEXTURE);
        class_1921 layer13 = class_1921.method_23572((class_2960)TGBlocks.QUARTZ_BRICKS_GRAVESTONE_TEXTURE);
        LAYERS.put(TGBlocks.GRAVESTONE, layer1);
        LAYERS.put(TGBlocks.COBBLESTONE_GRAVESTONE, layer2);
        LAYERS.put(TGBlocks.MOSSY_COBBLESTONE_GRAVESTONE, layer3);
        LAYERS.put(TGBlocks.DEEPSLATE_GRAVESTONE, layer4);
        LAYERS.put(TGBlocks.BLACKSTONE_GRAVESTONE, layer5);
        LAYERS.put(TGBlocks.CRACKED_BLACKSTONE_GRAVESTONE, layer6);
        LAYERS.put(TGBlocks.STONE_BRICKS_GRAVESTONE, layer7);
        LAYERS.put(TGBlocks.MOSSY_STONE_BRICKS_GRAVESTONE, layer8);
        LAYERS.put(TGBlocks.BRICKS_GRAVESTONE, layer9);
        LAYERS.put(TGBlocks.RED_SANDSTONE_GRAVESTONE, layer10);
        LAYERS.put(TGBlocks.SANDSTONE_GRAVESTONE, layer11);
        LAYERS.put(TGBlocks.GILDED_BLACKSTONE_GRAVESTONE, layer12);
        LAYERS.put(TGBlocks.QUARTZ_BRICKS_GRAVESTONE, layer13);
    }
}

