/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.entities.AngerableGraveyardEntity;
import com.finallion.graveyard.entities.HordeGraveyardEntity;
import com.finallion.graveyard.entities.LichEntity;
import com.finallion.graveyard.entities.ai.goals.GhoulMeleeAttackGoal;
import com.finallion.graveyard.init.TGSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhoulEntity
extends AngerableGraveyardEntity
implements GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UUID SLOWNESS_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A1");
    private static final class_1322 SLOWNESS_EFFECT;
    private static final class_2940<Byte> VARIANT;
    private static final class_2940<Integer> ATTACK_ANIM_TIMER;
    private static final class_2940<Integer> RAGE_ANIM_TIMER;
    private static final class_2940<Integer> ANIMATION;
    private static final class_2940<Integer> SPAWN_TIMER;
    private static final class_2940<Boolean> IS_RAGING;
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation WALK_ANIMATION = RawAnimation.begin().then("walk", Animation.LoopType.LOOP);
    private final RawAnimation RAGE_ANIMATION = RawAnimation.begin().then("rage", Animation.LoopType.LOOP);
    private final RawAnimation RUNNING_ANIMATION = RawAnimation.begin().then("running", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    protected static final int ANIMATION_IDLE = 0;
    protected static final int ANIMATION_WALK = 1;
    protected static final int ANIMATION_RAGE = 2;
    protected static final int ANIMATION_DEATH = 3;
    protected static final int ANIMATION_RUNNING = 4;
    protected static final int ANIMATION_MELEE = 5;
    protected static final int ANIMATION_SPAWN = 6;
    public final int ATTACK_ANIMATION_DURATION = 14;
    public final int RAGE_ANIMATION_DURATION = 35;
    public final int RAGE_ANIMATION_COOLDOWN = 300;

    public GhoulEntity(class_1299<? extends GhoulEntity> entityType, class_1937 world) {
        super(entityType, world, "ghoul");
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        byte variant = (byte)((byte)this.field_5974.method_43048(8) + 1);
        this.field_6011.method_12784(VARIANT, (Object)variant);
        this.field_6011.method_12784(ANIMATION, (Object)0);
        this.field_6011.method_12784(ATTACK_ANIM_TIMER, (Object)0);
        this.field_6011.method_12784(RAGE_ANIM_TIMER, (Object)0);
        this.field_6011.method_12784(SPAWN_TIMER, (Object)32);
        this.field_6011.method_12784(IS_RAGING, (Object)false);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new GhoulMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{LichEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public static class_5132.class_5133 createGhoulAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23719, 0.175).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23718, 0.5);
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public int getAnimationState() {
        return (Integer)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimationState(int state) {
        this.field_6011.method_12778(ANIMATION, (Object)state);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.field_6011.method_12789(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.field_6011.method_12778(ATTACK_ANIM_TIMER, (Object)time);
    }

    public int getSpawnTimer() {
        return (Integer)this.field_6011.method_12789(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.field_6011.method_12778(SPAWN_TIMER, (Object)ticks);
    }

    public int getRageAnimTimer() {
        return (Integer)this.field_6011.method_12789(RAGE_ANIM_TIMER);
    }

    public void setRageAnimTimer(int time) {
        this.field_6011.method_12778(RAGE_ANIM_TIMER, (Object)time);
    }

    public boolean isRaging() {
        return (Boolean)this.field_6011.method_12789(IS_RAGING);
    }

    public void setIsRaging(boolean raging) {
        this.field_6011.method_12778(IS_RAGING, (Object)raging);
    }

    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    protected void method_5958() {
        int animTimer;
        if (this.getAttackAnimTimer() == 14) {
            this.setAnimationState(5);
            if (this.getRageAnimTimer() <= 0) {
                this.setRageAnimTimer(300);
            }
        }
        if (this.getRageAnimTimer() == 35) {
            this.method_5783(TGSounds.GHOUL_ROAR, 1.0f, 1.0f);
            this.setIsRaging(true);
            this.setAnimationState(2);
            this.aggroMobs();
        }
        if (this.getAttackAnimTimer() > 0) {
            animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.getRageAnimTimer() > 0) {
            animTimer = this.getRageAnimTimer() - 1;
            this.setRageAnimTimer(animTimer);
        }
        if (this.getRageAnimTimer() == 0) {
            this.setIsRaging(false);
        }
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        super.method_5958();
    }

    @Override
    public void method_6007() {
        class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23719);
        if (this.isRaging()) {
            if (!entityAttributeInstance.method_6196(SLOWNESS_EFFECT)) {
                entityAttributeInstance.method_26835(SLOWNESS_EFFECT);
            }
        } else if (entityAttributeInstance.method_6196(SLOWNESS_EFFECT)) {
            entityAttributeInstance.method_6202(SLOWNESS_EFFECT);
        }
        super.method_6007();
    }

    public void method_5773() {
        if (this.getSpawnTimer() > 0 && this.method_5770() != null) {
            class_5819 random = this.method_6051();
            class_2680 blockState = this.method_25936();
            if (blockState.method_26217() != class_2464.field_11455) {
                for (int i = 0; i < 30; ++i) {
                    double d = this.method_23317() + (double)class_3532.method_32750((class_5819)random, (float)-0.7f, (float)0.7f);
                    double e = this.method_23318();
                    double f = this.method_23321() + (double)class_3532.method_32750((class_5819)random, (float)-0.7f, (float)0.7f);
                    this.method_5770().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), d, e, f, 0.0, 0.0, 0.0);
                }
            }
        }
        super.method_5773();
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("ghoulVariant", this.getVariant());
        nbt.method_10569("spawnTimer", this.getSpawnTimer());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(nbt.method_10571("ghoulVariant"));
        this.setSpawnTimer(nbt.method_10550("spawnTimer"));
    }

    private void aggroMobs() {
        if (this.method_5968() != null) {
            List monster = this.method_5770().method_8390(HordeGraveyardEntity.class, new class_238(this.method_24515()).method_1014(45.0), arg_0 -> ((GhoulEntity)this).method_6057(arg_0));
            for (HordeGraveyardEntity entity : monster) {
                entity.method_5980(this.method_5968());
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            boolean isMoving;
            float limbSwingAmount = event.getLimbSwingAmount();
            boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
            if (this.getSpawnTimer() > 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.method_29504() || (double)this.method_6032() < 0.01) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 5 && this.getAttackAnimTimer() == 13 && this.method_6510() && !this.method_29504() && !((double)this.method_6032() < 0.01)) {
                this.setAttackAnimTimer(12);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 2 && this.getRageAnimTimer() == 34 && this.isRaging()) {
                event.getController().setAnimation(this.RAGE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if ((event.isMoving() || isMoving) && this.getAttackAnimTimer() <= 0 && !this.isRaging()) {
                if (this.method_6510() && !this.method_5637()) {
                    event.getController().setAnimation(this.RUNNING_ANIMATION);
                } else {
                    event.getController().setAnimation(this.WALK_ANIMATION);
                }
                return PlayState.CONTINUE;
            }
            if (!event.isMoving() && !this.isRaging()) {
                event.getController().setAnimation(this.IDLE_ANIMATION);
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() <= 0 && !event.isMoving()) {
                this.setAnimationState(0);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() > 0) {
                this.setAnimationState(5);
                return PlayState.STOP;
            }
            if (this.getAttackAnimTimer() <= 0 && !this.method_29504() && !((double)this.method_6032() < 0.01) && this.getAnimationState() != 2) {
                this.setAnimationState(0);
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void method_5966() {
        this.method_5783(TGSounds.GHOUL_AMBIENT, 1.0f, -5.0f);
    }

    public void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(TGSounds.GHOUL_STEP, 0.5f, -1.0f);
    }

    protected void method_6013(class_1282 source) {
        this.method_5783(TGSounds.GHOUL_HURT, 1.0f, -5.0f);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.method_5783(TGSounds.GHOUL_DEATH, 1.0f, -5.0f);
    }

    static {
        VARIANT = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13319);
        ATTACK_ANIM_TIMER = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13327);
        RAGE_ANIM_TIMER = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13327);
        ANIMATION = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13327);
        SPAWN_TIMER = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13327);
        IS_RAGING = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13323);
        SLOWNESS_EFFECT = new class_1322(SLOWNESS_ID, "Slowness effect", -0.3, class_1322.class_1323.field_6328);
    }
}

