/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.entities.GraveyardMinionEntity;
import com.finallion.graveyard.entities.ai.goals.AttackWithOwnerGoal;
import com.finallion.graveyard.entities.ai.goals.FollowOwnerGoal;
import com.finallion.graveyard.entities.ai.goals.GhoulingMeleeAttackGoal;
import com.finallion.graveyard.entities.ai.goals.SitGoal;
import com.finallion.graveyard.entities.ai.goals.TrackOwnerAttackerGoal;
import com.finallion.graveyard.init.TGAdvancements;
import com.finallion.graveyard.init.TGBlocks;
import com.finallion.graveyard.init.TGParticles;
import com.finallion.graveyard.init.TGSounds;
import com.finallion.graveyard.item.BoneStaffItem;
import com.finallion.graveyard.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhoulingEntity
extends GraveyardMinionEntity
implements GeoEntity,
class_3908 {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> ATTACK_ANIM_TIMER;
    private static final class_2940<Integer> ANIMATION;
    private static final class_2940<Integer> SPAWN_TIMER;
    private static final class_2940<Integer> TELEPORT_TIMER;
    private static final class_2940<class_1799> STAFF;
    private static final class_2940<Boolean> COFFIN;
    private static final class_2940<Byte> VARIANT;
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation WALK_ANIMATION = RawAnimation.begin().then("walk", Animation.LoopType.LOOP);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    protected static final int ANIMATION_SPAWN = 0;
    protected static final int ANIMATION_IDLE = 1;
    protected static final int ANIMATION_MELEE = 2;
    protected static final int ANIMATION_WALK = 3;
    protected static final int ANIMATION_DEATH = 4;
    public final int ATTACK_ANIMATION_DURATION = 14;
    protected class_1263 inventory;
    private static final List<class_1792> GHOULING_HOLDABLE;

    public GhoulingEntity(class_1299<? extends GhoulingEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new GhoulingEscapeDangerGoal(1.5));
        this.field_6201.method_6277(2, (class_1352)new SitGoal(this));
        this.field_6201.method_6277(5, (class_1352)new GhoulingMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(6, (class_1352)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new TrackOwnerAttackerGoal(this));
        this.field_6185.method_6277(2, (class_1352)new AttackWithOwnerGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
    }

    public static class_5132.class_5133 createGhoulingAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23725, 2.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23721, 6.5).method_26868(class_5134.field_23719, 0.31).method_26868(class_5134.field_23717, 35.0);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANIMATION, (Object)1);
        this.field_6011.method_12784(STAFF, (Object)class_1799.field_8037);
        this.field_6011.method_12784(ATTACK_ANIM_TIMER, (Object)0);
        this.field_6011.method_12784(COFFIN, (Object)false);
        this.field_6011.method_12784(SPAWN_TIMER, (Object)0);
        this.field_6011.method_12784(TELEPORT_TIMER, (Object)0);
        this.field_6011.method_12784(VARIANT, (Object)0);
    }

    protected void method_5958() {
        if (this.getAttackAnimTimer() == 14) {
            this.setAnimationState(2);
        }
        if (this.getAttackAnimTimer() > 0) {
            int animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        if (this.getTeleportTimer() > 0) {
            this.setTeleportTimer(this.getTeleportTimer() - 1);
        }
        if (this.method_6032() < this.method_6063()) {
            this.method_6025(0.01f);
        }
        super.method_5958();
    }

    public void method_6007() {
        if (this.getSpawnTimer() == 50) {
            this.method_5770().method_8396(null, this.method_24515(), TGSounds.GHOULING_SPAWN, class_3419.field_15251, 5.0f, 1.5f);
            this.method_5770().method_8396(null, this.method_24515(), TGSounds.GHOUL_ROAR, class_3419.field_15251, 1.0f, -2.0f);
        }
        if (this.isInSittingPose() && this.field_5974.method_43048(5) == 0) {
            MathUtil.createParticleCircle(this.method_5770(), this.method_23317(), this.method_23318() + 0.6, this.method_23321(), 0.0, 0.0, 0.0, 1.5f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.method_5770().field_9229, 0.5f);
        }
        if (this.getTeleportTimer() > 0) {
            if (this.getTeleportTimer() == 10) {
                this.method_5783(class_3417.field_23060, 2.0f, -10.0f);
            }
            MathUtil.createParticleCircle(this.method_5770(), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0, 1.5f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.method_5770().field_9229, 0.5f);
            MathUtil.createParticleCircle(this.method_5770(), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0, 1.5f, class_2398.field_22246, this.method_5770().field_9229, 0.5f);
        }
        super.method_6007();
    }

    public void method_5773() {
        if (this.getSpawnTimer() > 0 && this.method_5770() != null) {
            class_5819 random = this.method_6051();
            class_2680 blockState = this.method_25936();
            if (blockState.method_26217() != class_2464.field_11455) {
                for (int i = 0; i < 30; ++i) {
                    double d = this.method_23317() + (double)class_3532.method_32750((class_5819)random, (float)-0.7f, (float)0.7f);
                    double e = this.method_23318();
                    double f = this.method_23321() + (double)class_3532.method_32750((class_5819)random, (float)-0.7f, (float)0.7f);
                    this.method_5770().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), d, e, f, 0.0, 0.0, 0.0);
                }
            }
        }
        super.method_5773();
    }

    public int getAnimationState() {
        return (Integer)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimationState(int state) {
        this.field_6011.method_12778(ANIMATION, (Object)state);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.field_6011.method_12789(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.field_6011.method_12778(ATTACK_ANIM_TIMER, (Object)time);
    }

    public int getTeleportTimer() {
        return (Integer)this.field_6011.method_12789(TELEPORT_TIMER);
    }

    public void setTeleportTimer(int time) {
        this.field_6011.method_12778(TELEPORT_TIMER, (Object)time);
    }

    public void onSummoned() {
        this.setAnimationState(0);
        this.setSpawnTimer(50);
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            if (this.getAnimationState() == 0 && this.getSpawnTimer() >= 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, event -> {
            if (this.method_29504() || (double)this.method_6032() < 0.01) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 2 && this.getAttackAnimTimer() == 13 && this.method_6510() && !this.method_29504() && !((double)this.method_6032() < 0.01)) {
                this.setAttackAnimTimer(12);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if ((this.getAnimationState() == 3 || event.isMoving()) && this.getAttackAnimTimer() <= 0) {
                event.getController().setAnimation(this.WALK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 1 && this.getAttackAnimTimer() <= 0 && this.getSpawnTimer() <= 0) {
                event.getController().setAnimation(this.IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 1 && this.getAttackAnimTimer() > 0) {
                this.setAnimationState(2);
                return PlayState.STOP;
            }
            if (this.getAttackAnimTimer() <= 0 && !this.method_29504() && !((double)this.method_6032() < 0.01) && this.getSpawnTimer() <= 0) {
                this.setAnimationState(1);
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (!this.method_5770().method_8608() && this.isOwner((class_1309)player)) {
            if (this.hasCoffin() && player.method_5715()) {
                player.method_17355((class_3908)this);
                return class_1269.field_5812;
            }
            if (!itemStack.method_7960() && !this.hasCoffin() && GHOULING_HOLDABLE.contains(itemStack.method_7909())) {
                this.method_5673(class_1304.field_6171, new class_1799((class_1935)itemStack.method_7909()));
                if (this.inventory == null) {
                    this.method_5783(class_3417.field_14823, 1.0f, -5.0f);
                    TGAdvancements.EQUIP_COFFIN.trigger((class_3222)player);
                    this.inventory = new class_1277(54);
                    this.setHasCoffin(true);
                }
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (itemStack.method_7909() instanceof BoneStaffItem && !player.method_5715()) {
                class_1269 actionResult = super.method_5992(player, hand);
                if (!actionResult.method_23665()) {
                    this.method_5783(TGSounds.GHOULING_GROAN, 1.0f, -2.0f);
                    if (this.isInSittingPose()) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"entity.graveyard.ghouling.nowait"), true);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"entity.graveyard.ghouling.wait"), true);
                    }
                    this.setSitting(!this.isSitting());
                    this.field_6282 = false;
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    return class_1269.field_5812;
                }
                return actionResult;
            }
        }
        return super.method_5992(player, hand);
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 44 && !this.method_5770().method_8608()) {
            this.method_5770().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public int getSpawnTimer() {
        return (Integer)this.field_6011.method_12789(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.field_6011.method_12778(SPAWN_TIMER, (Object)ticks);
    }

    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public class_1799 getStaff() {
        return (class_1799)this.field_6011.method_12789(STAFF);
    }

    public void setStaff(class_1799 staff) {
        this.field_6011.method_12778(STAFF, (Object)staff);
    }

    public boolean hasCoffin() {
        return (Boolean)this.field_6011.method_12789(COFFIN);
    }

    public void setHasCoffin(boolean hasCoffin) {
        this.field_6011.method_12778(COFFIN, (Object)hasCoffin);
    }

    protected void method_16078() {
        super.method_16078();
        if (this.hasCoffin()) {
            if (!this.method_5770().field_9236) {
                this.method_5706((class_1935)this.method_6079().method_7909());
                if (this.inventory != null) {
                    for (int i = 0; i < this.inventory.method_5439(); ++i) {
                        class_1799 stack = this.inventory.method_5438(i);
                        if (stack.method_7960() || class_1890.method_8221((class_1799)stack)) continue;
                        this.method_5775(stack);
                    }
                }
            }
            this.setHasCoffin(false);
        }
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.method_5770().method_8608()) {
            BoneStaffItem.ownerGhoulingMapping.remove(this.method_5667(), this.getOwnerUuid());
        }
        super.method_6078(damageSource);
        this.method_5783(TGSounds.GHOULING_DEATH, 1.0f, -2.0f);
    }

    public void method_5966() {
        this.method_5783(TGSounds.GHOULING_AMBIENT, 1.0f, -1.0f);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(TGSounds.GHOULING_STEP, 0.3f, 0.0f);
    }

    protected void method_6013(class_1282 source) {
        this.method_5783(TGSounds.GHOULING_HURT, 1.0f, -1.0f);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("CoffinGhouling", this.hasCoffin());
        nbt.method_10567("ghoulVariant", this.getVariant());
        if (this.getStaff() != null) {
            nbt.method_10566("Staff", (class_2520)this.getStaff().method_7953(new class_2487()));
        }
        if (this.inventory != null) {
            class_2499 inv = new class_2499();
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                inv.add((Object)this.inventory.method_5438(i).method_7953(new class_2487()));
            }
            nbt.method_10566("Inventory", (class_2520)inv);
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasCoffin(nbt.method_10577("CoffinGhouling"));
        this.setVariant(nbt.method_10571("ghoulVariant"));
        if (nbt.method_10545("Staff")) {
            this.setStaff(class_1799.method_7915((class_2487)nbt.method_10562("Staff")));
        }
        if (nbt.method_10545("Inventory")) {
            class_2499 inv = nbt.method_10554("Inventory", 10);
            this.inventory = new class_1277(inv.size());
            for (int i = 0; i < inv.size(); ++i) {
                this.inventory.method_5447(i, class_1799.method_7915((class_2487)inv.method_10602(i)));
            }
        }
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        if (this.inventory == null) {
            return null;
        }
        return class_1707.method_19247((int)syncId, (class_1661)inv, (class_1263)this.inventory);
    }

    static {
        GHOULING_HOLDABLE = new ArrayList<class_1792>();
        GHOULING_HOLDABLE.add(TGBlocks.SARCOPHAGUS.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.OAK_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.DARK_OAK_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.SPRUCE_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.BIRCH_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.JUNGLE_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.ACACIA_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.MANGROVE_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.WARPED_COFFIN.method_8389());
        GHOULING_HOLDABLE.add(TGBlocks.CRIMSON_COFFIN.method_8389());
        ATTACK_ANIM_TIMER = class_2945.method_12791(GhoulingEntity.class, (class_2941)class_2943.field_13327);
        ANIMATION = class_2945.method_12791(GhoulingEntity.class, (class_2941)class_2943.field_13327);
        SPAWN_TIMER = class_2945.method_12791(GhoulingEntity.class, (class_2941)class_2943.field_13327);
        TELEPORT_TIMER = class_2945.method_12791(GhoulingEntity.class, (class_2941)class_2943.field_13327);
        COFFIN = class_2945.method_12791(GhoulingEntity.class, (class_2941)class_2943.field_13323);
        VARIANT = class_2945.method_12791(GhoulingEntity.class, (class_2941)class_2943.field_13319);
        STAFF = class_2945.method_12791(GhoulingEntity.class, (class_2941)class_2943.field_13322);
    }

    class GhoulingEscapeDangerGoal
    extends class_1374 {
        public GhoulingEscapeDangerGoal(double speed) {
            super((class_1314)GhoulingEntity.this, speed);
        }

        protected boolean method_40072() {
            return this.field_6549.method_40071() || this.field_6549.method_5809();
        }
    }
}

