/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3321;
import net.minecraft.class_7;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GraveyardMinionEntity
extends class_1314 {
    protected static final class_2940<Optional<UUID>> OWNER_UUID;
    protected static final class_2940<Byte> TAMEABLE_FLAGS;
    private boolean sitting;

    public GraveyardMinionEntity(class_1299<? extends GraveyardMinionEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_33534, -1.0f);
        this.method_5941(class_7.field_36432, -1.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(TAMEABLE_FLAGS, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.getOwnerUuid() != null) {
            nbt.method_25927("Owner", this.getOwnerUuid());
        }
        nbt.method_10556("Sitting", this.sitting);
    }

    public void method_5749(class_2487 nbt) {
        UUID uUID;
        super.method_5749(nbt);
        if (nbt.method_25928("Owner")) {
            uUID = nbt.method_25926("Owner");
        } else {
            String string = nbt.method_10558("Owner");
            uUID = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)string);
        }
        if (uUID != null) {
            try {
                this.setOwnerUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.sitting = nbt.method_10577("Sitting");
        this.setInSittingPose(this.sitting);
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(class_1657 player) {
        this.setOwnerUuid(player.method_5667());
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public boolean isInSittingPose() {
        return ((Byte)this.field_6011.method_12789(TAMEABLE_FLAGS) & 1) != 0;
    }

    public void setInSittingPose(boolean inSittingPose) {
        byte b = (Byte)this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (inSittingPose) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b | 1)));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uUID = this.getOwnerUuid();
            return uUID == null ? null : this.method_5770().method_18470(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean method_18395(class_1309 target) {
        return this.isOwner(target) ? false : super.method_18395(target);
    }

    public boolean isOwner(class_1309 entity) {
        return entity == this.getOwner();
    }

    public boolean method_5722(class_1297 other) {
        class_1309 livingEntity = this.getOwner();
        if (other == livingEntity) {
            return true;
        }
        if (livingEntity != null) {
            return livingEntity.method_5722(other);
        }
        return super.method_5722(other);
    }

    public boolean canAttackWithOwner(class_1309 target, class_1309 owner) {
        if (!(target instanceof class_1548) && !(target instanceof class_1571)) {
            if (target instanceof GraveyardMinionEntity) {
                GraveyardMinionEntity minion = (GraveyardMinionEntity)target;
                return minion.getOwner() != owner;
            }
            if (target instanceof class_1657 && owner instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)target)) {
                return false;
            }
            if (target instanceof class_1496 && ((class_1496)target).method_6727()) {
                return false;
            }
            return !(target instanceof class_1321) || !((class_1321)target).method_6181();
        }
        return false;
    }

    static {
        TAMEABLE_FLAGS = class_2945.method_12791(GraveyardMinionEntity.class, (class_2941)class_2943.field_13319);
        OWNER_UUID = class_2945.method_12791(GraveyardMinionEntity.class, (class_2941)class_2943.field_13313);
    }
}

