/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.blocks.BrazierBlock;
import com.finallion.graveyard.entities.HostileGraveyardEntity;
import com.finallion.graveyard.init.TGAdvancements;
import com.finallion.graveyard.init.TGSounds;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1395;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_5544;
import net.minecraft.class_5996;
import net.minecraft.class_7;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WraithEntity
extends HostileGraveyardEntity
implements GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final class_1322 ATTACKING_SPEED_BOOST = new class_1322(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", 0.2, class_1322.class_1323.field_6328);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation MOVE_ANIMATION = RawAnimation.begin().then("moving", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attacking", Animation.LoopType.LOOP);
    protected final byte ANIMATION_SPAWN = 0;
    protected final byte ANIMATION_IDLE = 1;
    protected final byte ANIMATION_DEATH = (byte)2;
    protected final byte ANIMATION_ATTACK = (byte)3;
    protected static final class_2940<Byte> ANIMATION = class_2945.method_12791(WraithEntity.class, (class_2941)class_2943.field_13319);
    private boolean spawned = false;
    private int spawnTimer;
    @Nullable
    private class_2338 homePosition;
    private int timeSinceExtinguish;

    public WraithEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world, "wraith");
        this.field_6207 = new class_1331((class_1308)this, 0, true);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        this.method_5852();
    }

    public void method_5844(class_2680 state, class_243 multiplier) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, multiplier);
        }
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new WraithMeleeGoal((class_1314)this, 1.0, false));
        this.field_6201.method_6277(3, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new ExtinguishGoal());
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }

            public void method_6360() {
                super.method_6360();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42247)) {
            class_1297 entity = source.method_5526();
            if (entity instanceof class_1667) {
                return false;
            }
            return super.method_5643(source, amount);
        }
        return super.method_5643(source, amount);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANIMATION, (Object)1);
        this.spawnTimer = 20;
        this.setAnimation((byte)0);
    }

    public void method_5773() {
        super.method_5773();
        this.method_5875(true);
        if (this.getHomePosition() == null) {
            this.homePosition = this.method_24515();
        }
        if (this.field_5974.method_43057() < 0.025f) {
            this.addParticles();
        }
    }

    private class_2338 getHomePosition() {
        return this.homePosition;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.homePosition != null) {
            nbt.method_10569("BoundX", this.homePosition.method_10263());
            nbt.method_10569("BoundY", this.homePosition.method_10264());
            nbt.method_10569("BoundZ", this.homePosition.method_10260());
        }
        nbt.method_10569("timeSinceExtinguish", this.timeSinceExtinguish);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("BoundX")) {
            this.homePosition = new class_2338(nbt.method_10550("BoundX"), nbt.method_10550("BoundY"), nbt.method_10550("BoundZ"));
        }
        this.timeSinceExtinguish = nbt.method_10550("timeSinceExtinguish");
    }

    @Override
    public void method_6007() {
        --this.spawnTimer;
        if (this.method_5770().method_8608() && this.spawnTimer >= 0 && this.spawned) {
            this.addParticles();
        }
        class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23720);
        if (!this.method_6510()) {
            entityAttributeInstance.method_6202(ATTACKING_SPEED_BOOST);
        } else if (!entityAttributeInstance.method_6196(ATTACKING_SPEED_BOOST)) {
            entityAttributeInstance.method_26835(ATTACKING_SPEED_BOOST);
        }
        if (!this.method_5805()) {
            this.addDeathParticles();
        }
        super.method_6007();
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        world.method_8396(null, this.method_24515(), class_3417.field_23060, class_3419.field_15251, 2.0f, -5.0f);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 42 && !this.method_5770().method_8608()) {
            this.method_5770().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    private void addParticles() {
        this.method_5770().method_8406((class_2394)class_2398.field_23114, this.method_23317() + (this.field_5974.method_43058() - this.field_5974.method_43058()), this.method_23318(), this.method_23321() + (this.field_5974.method_43058() - this.field_5974.method_43058()), 0.0, (double)0.05f, 0.0);
    }

    private void addDeathParticles() {
        for (int i = 0; i < 10; ++i) {
            this.method_5770().method_8406((class_2394)class_2398.field_11251, this.method_23317() + (this.field_5974.method_43058() - this.field_5974.method_43058()), this.method_23318() + 1.0, this.method_23321() + (this.field_5974.method_43058() - this.field_5974.method_43058()), 0.0, (double)0.05f, 0.0);
        }
    }

    int getTimeSinceExtinguish() {
        return this.timeSinceExtinguish;
    }

    void addExtinguishCounter() {
        ++this.timeSinceExtinguish;
    }

    @class_5996
    public boolean hasHomePosition() {
        return this.homePosition != null;
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_48789(class_8103.field_42241) || damageSource.method_48789(class_8103.field_42243) || damageSource.method_48789(class_8103.field_43116)) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public static class_5132.class_5133 createWraithAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 27.5).method_26868(class_5134.field_23721, 6.5).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23720, 0.35);
    }

    public byte getAnimation() {
        return (Byte)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, event -> {
            boolean isMoving;
            AnimationController controller = event.getController();
            float limbSwingAmount = event.getLimbSwingAmount();
            boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
            if (this.method_29504()) {
                controller.setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.spawnTimer < 0) {
                if (this.method_6510()) {
                    controller.setAnimation(this.ATTACK_ANIMATION);
                } else if (isMoving) {
                    controller.setAnimation(this.MOVE_ANIMATION);
                } else {
                    controller.setAnimation(this.IDLE_ANIMATION);
                }
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, event -> {
            if (this.getAnimation() == 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                this.spawned = true;
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    boolean isWithinDistance(class_2338 pos, int distance) {
        if (pos == null) {
            return false;
        }
        return pos.method_19771((class_2382)this.method_24515(), (double)distance);
    }

    public void method_5966() {
        this.method_5783(TGSounds.WRAITH_AMBIENT, 1.5f, -10.0f);
    }

    protected void method_6013(class_1282 source) {
        this.method_5783(TGSounds.WRAITH_HURT, 1.0f, -10.0f);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.playDeathSound();
    }

    private void playDeathSound() {
        for (int i = 0; i < 10; ++i) {
            this.method_5783(TGSounds.WRAITH_AMBIENT, 2.5f, -10.0f);
        }
    }

    public boolean method_30949(class_1297 other) {
        if (other instanceof WraithEntity) {
            return false;
        }
        return super.method_30949(other);
    }

    protected void method_23328() {
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    private static void triggerAdvancement(WraithEntity wraith, boolean bool) {
        class_1657 player;
        if (bool && (player = wraith.method_5770().method_18460((class_1297)wraith, 10.0)) instanceof class_3222) {
            TGAdvancements.DIM_LIGHT.trigger((class_3222)player);
        }
    }

    class WraithMeleeGoal
    extends class_1366 {
        WraithMeleeGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        public boolean method_6264() {
            return super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266();
        }
    }

    private class ExtinguishGoal
    extends class_1352 {
        ExtinguishGoal() {
        }

        public boolean method_6264() {
            if (WraithEntity.this.getTimeSinceExtinguish() >= 10) {
                return false;
            }
            return !(WraithEntity.this.field_5974.method_43057() < 0.3f);
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6268() {
            if (WraithEntity.this.field_5974.method_43048(this.method_38847(10)) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    class_2338 blockPos = WraithEntity.this.method_24515().method_10087(i);
                    class_2680 blockState = WraithEntity.this.method_5770().method_8320(blockPos);
                    class_2248 block = blockState.method_26204();
                    boolean bl = false;
                    boolean torchAndLantern = false;
                    if (blockState.method_26164(class_3481.field_26983)) {
                        if (block instanceof class_5544) {
                            if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                                bl = true;
                            }
                        } else if (block instanceof BrazierBlock && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                            bl = true;
                        }
                        if (bl) {
                            WraithEntity.this.method_5770().method_8396((class_1657)null, blockPos, class_3417.field_26955, class_3419.field_15245, 1.0f, 1.0f);
                            WraithEntity.this.method_5770().method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)));
                            WraithEntity.this.addExtinguishCounter();
                            WraithEntity.triggerAdvancement(WraithEntity.this, bl);
                            return;
                        }
                    }
                    if (WraithEntity.this.field_5974.method_43048(10) != 0) continue;
                    if (blockState.method_27852(class_2246.field_10336)) {
                        WraithEntity.this.method_5770().method_8501(blockPos, class_2246.field_22092.method_9564());
                        torchAndLantern = true;
                    } else if (blockState.method_27852(class_2246.field_16541)) {
                        WraithEntity.this.method_5770().method_8501(blockPos, (class_2680)((class_2680)class_2246.field_22110.method_9564().method_11657((class_2769)class_2741.field_16561, (Comparable)((Boolean)blockState.method_11654((class_2769)class_2741.field_16561)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)blockState.method_11654((class_2769)class_2741.field_12508))));
                        torchAndLantern = true;
                    } else if (blockState.method_27852(class_2246.field_10099)) {
                        WraithEntity.this.method_5770().method_8501(blockPos, (class_2680)class_2246.field_22093.method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2383.field_11177))));
                        torchAndLantern = true;
                    }
                    if (!torchAndLantern) continue;
                    WraithEntity.this.method_5770().method_8396((class_1657)null, blockPos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
                    WraithEntity.this.addExtinguishCounter();
                    return;
                }
            }
        }
    }

    class WraithWanderAroundGoal
    extends class_1352 {
        private static final int MAX_DISTANCE = 15;

        WraithWanderAroundGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return WraithEntity.this.field_6189.method_6357() && WraithEntity.this.field_5974.method_43048(10) == 0;
        }

        public boolean method_6266() {
            return WraithEntity.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                WraithEntity.this.field_6189.method_6334(WraithEntity.this.field_6189.method_6348(class_2338.method_49638((class_2374)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private class_243 getRandomLocation() {
            class_243 vec3d2;
            if (!WraithEntity.this.isWithinDistance(WraithEntity.this.homePosition, 15) && WraithEntity.this.hasHomePosition()) {
                class_243 vec3dx = class_243.method_24953((class_2382)WraithEntity.this.homePosition);
                vec3d2 = vec3dx.method_1020(WraithEntity.this.method_19538()).method_1029();
            } else {
                vec3d2 = WraithEntity.this.method_5828(0.0f);
            }
            class_243 vec3d3 = class_5533.method_31524((class_1314)WraithEntity.this, (int)8, (int)2, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (float)1.5707964f, (int)2, (int)1);
            return vec3d3 != null ? vec3d3 : class_5530.method_31504((class_1314)WraithEntity.this, (int)8, (int)2, (int)-2, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (double)1.5707963705062866);
        }
    }
}

