/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.util;

import com.finallion.graveyard.TheGraveyard;
import com.finallion.graveyard.item.BoneStaffItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class TGFileWriterReader {

    public static class Unload
    implements ServerWorldEvents.Unload {
        public void onWorldUnload(MinecraftServer server, class_3218 world) {
            this.saveGhoulingUUIDFile(server);
        }

        private void saveGhoulingUUIDFile(MinecraftServer server) {
            try {
                FileWriter fileWriter = new FileWriter(server.method_27050(class_5218.field_24188).toString() + "/graveyardGhoulingUUIDmapping.txt");
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                for (Map.Entry<UUID, UUID> entry : BoneStaffItem.ownerGhoulingMapping.entrySet()) {
                    bufferedWriter.write(entry.getKey() + ":" + entry.getValue());
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Load
    implements ServerWorldEvents.Load {
        public void onWorldLoad(MinecraftServer server, class_3218 world) {
            this.readGhoulingUUIDFile(server);
        }

        private void readGhoulingUUIDFile(MinecraftServer server) {
            File file = new File(server.method_27050(class_5218.field_24188).toString() + "/graveyardGhoulingUUIDmapping.txt");
            if (file.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(server.method_27050(class_5218.field_24188).toString() + "/graveyardGhoulingUUIDmapping.txt"));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] keyValuePair = line.split(":", 2);
                        if (keyValuePair.length <= 1) continue;
                        String key = keyValuePair[0];
                        String value = keyValuePair[1];
                        BoneStaffItem.ownerGhoulingMapping.putIfAbsent(UUID.fromString(key), UUID.fromString(value));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ServerStarted
    implements ServerLifecycleEvents.ServerStarted {
        public void onServerStarted(MinecraftServer server) {
            File oldConfig = new File(FabricLoader.getInstance().getConfigDir().toString() + "/the-graveyard-config.json5");
            File oldConfig2 = new File(FabricLoader.getInstance().getConfigDir().toString() + "/the-graveyard-1.19-config.json5");
            File oldConfig3 = new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.0-config.json5");
            File oldConfig4 = new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.2-config.json5");
            File oldConfig5 = new File(FabricLoader.getInstance().getConfigDir().toString() + "/graveyard/the-graveyard-2.5-config.json5");
            if (oldConfig.exists() && oldConfig.delete()) {
                TheGraveyard.LOGGER.info("Deleting old Graveyard Config file.");
            }
            if (oldConfig2.exists() && oldConfig2.delete()) {
                TheGraveyard.LOGGER.info("Deleting old Graveyard Config file.");
            }
            if (oldConfig3.exists() && oldConfig3.delete()) {
                TheGraveyard.LOGGER.info("Deleting old Graveyard Config file.");
            }
            if (oldConfig4.exists() && oldConfig4.delete()) {
                TheGraveyard.LOGGER.info("Deleting old Graveyard Config file.");
            }
            if (oldConfig5.exists() && oldConfig5.delete()) {
                TheGraveyard.LOGGER.info("Deleting old Graveyard Config file.");
            }
        }
    }
}

