/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network;

import java.util.Map;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.AzureLibException;
import mod.azure.azurelib.config.ConfigHolder;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.network.Networking;
import mod.azure.azurelib.network.api.IClientPacket;
import mod.azure.azurelib.network.api.IPacketDecoder;
import mod.azure.azurelib.network.api.IPacketEncoder;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class S2C_SendConfigData
implements IClientPacket<ConfigData> {
    public static final class_2960 IDENTIFIER = new class_2960("azurelib", "s2c_send_config_data");
    private final ConfigData config;

    S2C_SendConfigData() {
        this.config = null;
    }

    public S2C_SendConfigData(String config) {
        this.config = new ConfigData(config);
    }

    @Override
    public class_2960 getPacketId() {
        return IDENTIFIER;
    }

    @Override
    public ConfigData getPacketData() {
        return this.config;
    }

    @Override
    public IPacketEncoder<ConfigData> getEncoder() {
        return (configData, buffer) -> {
            buffer.method_10814(configData.configId);
            ConfigHolder.getConfig(configData.configId).ifPresent(data -> {
                Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
                buffer.writeInt(serialized.size());
                for (Map.Entry<String, ConfigValue<?>> entry : serialized.entrySet()) {
                    String id = entry.getKey();
                    ConfigValue<?> value = entry.getValue();
                    TypeAdapter adapter = value.getAdapter();
                    buffer.method_10814(id);
                    adapter.encodeToBuffer(value, buffer);
                }
            });
        };
    }

    @Override
    public IPacketDecoder<ConfigData> getDecoder() {
        return buffer -> {
            String config = buffer.method_19772();
            int i = buffer.readInt();
            ConfigHolder.getConfig(config).ifPresent(data -> {
                Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
                for (int j = 0; j < i; ++j) {
                    String fieldId = buffer.method_19772();
                    ConfigValue<?> value = serialized.get(fieldId);
                    if (value == null) {
                        AzureLib.LOGGER.fatal(Networking.MARKER, "Received unknown config value " + fieldId);
                        throw new AzureLibException("Unknown config field: " + fieldId);
                    }
                    this.setValue(value, buffer);
                }
            });
            return new ConfigData(config);
        };
    }

    @Override
    public void handleClientsidePacket(class_310 client, class_634 listener, ConfigData packetData, PacketSender dispatcher) {
    }

    private <V> void setValue(ConfigValue<V> value, class_2540 buffer) {
        TypeAdapter adapter = value.getAdapter();
        Object v = adapter.decodeFromBuffer(value, buffer);
        value.set(v);
    }

    static final class ConfigData {
        private final String configId;

        public ConfigData(String configId) {
            this.configId = configId;
        }
    }
}

