/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.dynamictrim.resource;

import io.github.andrew6rant.dynamictrim.DynamicTrimClient;
import io.github.andrew6rant.dynamictrim.json.JsonHelper;
import io.github.andrew6rant.dynamictrim.resource.OverrideResource;
import io.github.andrew6rant.dynamictrim.resource.TrimModelHelper;
import io.github.andrew6rant.dynamictrim.resource.TrimmableItem;
import io.github.andrew6rant.dynamictrim.resource.TrimmableResource;
import io.github.andrew6rant.dynamictrim.util.DebugHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_7923;

public class DynamicTrimLoader {
    private static final Set<Supplier<Collection<TrimmableItem>>> CUSTOM = new HashSet<Supplier<Collection<TrimmableItem>>>();

    public static void addCustom(Supplier<Collection<TrimmableItem>> item) {
        CUSTOM.add(item);
    }

    private static String getArmourType(class_1738 value) {
        return switch (value.method_7685()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1304.field_6169 -> "helmet";
            case class_1304.field_6174 -> "chestplate";
            case class_1304.field_6172 -> "leggings";
            case class_1304.field_6166 -> "boots";
            case class_1304.field_6173, class_1304.field_6171 -> null;
        };
    }

    private static List<TrimmableItem> getArmourEntries() {
        ArrayList<TrimmableItem> entries = new ArrayList<TrimmableItem>();
        class_7923.field_41178.forEach(item -> {
            if (!(item instanceof class_1738)) {
                return;
            }
            class_1738 armour = (class_1738)item;
            class_2960 id = class_7923.field_41178.method_10221(item);
            if (id.method_12836().equals("betterend")) {
                return;
            }
            String armourType = DynamicTrimLoader.getArmourType(armour);
            if (armourType != null) {
                entries.add(new TrimmableItem(armourType, id));
            }
        });
        return entries;
    }

    public static void loadDynamicTrims(Map<class_2960, class_3298> resourceMap) {
        List<TrimmableItem> trimmables = DynamicTrimLoader.getArmourEntries();
        CUSTOM.forEach(supplier -> trimmables.addAll((Collection)supplier.get()));
        for (TrimmableItem item : trimmables) {
            DynamicTrimLoader.loadTrims(item, resourceMap);
        }
    }

    private static void loadTrims(TrimmableItem item, Map<class_2960, class_3298> resourceMap) {
        class_2960 equipmentId = item.id();
        TrimmableResource equipmentResource = TrimModelHelper.buildResource(item, resourceMap);
        if (equipmentResource == null) {
            DynamicTrimClient.LOGGER.warn("Item %s's resource could not be built, skipping".formatted(equipmentId), new Object[0]);
            return;
        }
        resourceMap.put(item.resourceId(), equipmentResource.createDynamicResource());
        DebugHelper.createDebugFile("models", "%s.json".formatted(equipmentId), equipmentResource.modelString());
        equipmentResource.forEachOverride((override, material) -> {
            for (class_2960 patternId : TrimModelHelper.TEMPLATE_IDS) {
                OverrideResource overrideResource = equipmentResource.createOverrideResource(patternId, (String)material);
                resourceMap.put(overrideResource.modelId(), overrideResource.toResource(equipmentResource.resource().method_45304()));
                DebugHelper.createDebugFile("models", "models/%s/trims/%s/%s_trim.json".formatted(equipmentResource.baseTextureId().method_12832(), patternId.toString().replace(":", "-"), material), JsonHelper.toJsonString(overrideResource.modelResourceJson()));
            }
        });
    }
}

