/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class ItemAttributeModifierEvent {
    public static final Event<ItemAttributeModifier> GATHER_TOOLTIPS = EventFactory.createArrayBacked(ItemAttributeModifier.class, callbacks -> event -> {
        for (ItemAttributeModifier callback : callbacks) {
            callback.gatherTooltips(event);
        }
    });

    @FunctionalInterface
    public static interface ItemAttributeModifier {
        public void gatherTooltips(AttributeModifierEvent var1);
    }

    public static class AttributeModifierEvent {
        public final Multimap<class_1320, class_1322> originalModifiers;
        public Multimap<class_1320, class_1322> nonChangableModifiers;
        @Nullable
        private Multimap<class_1320, class_1322> changableModifiers;
        public final class_1799 stack;
        public final class_1304 slot;

        public AttributeModifierEvent(class_1799 stack, class_1304 slot, Multimap<class_1320, class_1322> modifiers) {
            this.stack = stack;
            this.slot = slot;
            this.originalModifiers = modifiers;
            this.nonChangableModifiers = this.originalModifiers;
        }

        private Multimap<class_1320, class_1322> getModifiableMap() {
            if (this.changableModifiers == null) {
                this.changableModifiers = HashMultimap.create(this.originalModifiers);
                this.nonChangableModifiers = Multimaps.unmodifiableMultimap(this.changableModifiers);
            }
            return this.changableModifiers;
        }

        public boolean addModifier(class_1320 attribute, class_1322 modifier) {
            return this.getModifiableMap().put((Object)attribute, (Object)modifier);
        }

        public boolean removeModifier(class_1320 attribute, class_1322 modifier) {
            return this.getModifiableMap().remove((Object)attribute, (Object)modifier);
        }

        public Collection<class_1322> removeAttribute(class_1320 attribute) {
            return this.getModifiableMap().removeAll((Object)attribute);
        }

        public void clearModifiers() {
            this.getModifiableMap().clear();
        }
    }
}

