/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.parsing;

import java.util.Collection;
import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.expression.VariableExpression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import kroppeb.stareval.function.TypedFunction;
import net.coderbot.iris.parsing.VectorType;

public class VectorizedFunction
implements TypedFunction {
    final TypedFunction inner;
    final int size;
    final VectorType.ArrayVector returnType;
    final TypedFunction.Parameter[] parameters;
    private final ElementAccessExpression[] vectorAccessors;
    private int index;
    private final VectorType.ArrayVector.IntObjectObjectObjectConsumer<VectorizedFunction, FunctionContext, FunctionReturn> mapper = (n, vectorizedFunction, functionContext, functionReturn) -> {
        vectorizedFunction.index = n;
        vectorizedFunction.inner.evaluateTo(vectorizedFunction.vectorAccessors, (FunctionContext)functionContext, (FunctionReturn)functionReturn);
    };

    public VectorizedFunction(TypedFunction typedFunction, int n2) {
        this.inner = typedFunction;
        this.size = n2;
        this.returnType = new VectorType.ArrayVector(typedFunction.getReturnType(), n2);
        TypedFunction.Parameter[] parameterArray = typedFunction.getParameters();
        this.parameters = new TypedFunction.Parameter[parameterArray.length];
        this.vectorAccessors = new ElementAccessExpression[parameterArray.length];
        for (int i = 0; i < parameterArray.length; ++i) {
            this.parameters[i] = new TypedFunction.Parameter(new VectorType.ArrayVector(parameterArray[i].type(), n2));
            this.vectorAccessors[i] = new ElementAccessExpression(parameterArray[i].type());
        }
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public TypedFunction.Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            expression.evaluateTo(functionContext, functionReturn);
            this.vectorAccessors[i].vector = functionReturn.objectReturn;
        }
        this.returnType.map(this, functionContext, functionReturn, this.mapper);
    }

    class ElementAccessExpression
    implements Expression {
        final Type parameterType;
        Object vector;

        ElementAccessExpression(Type type) {
            this.parameterType = type;
        }

        @Override
        public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
            this.parameterType.getValueFromArray(this.vector, VectorizedFunction.this.index, functionReturn);
        }

        @Override
        public void listVariables(Collection<? super VariableExpression> collection) {
            throw new IllegalStateException();
        }
    }
}

