/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigCommon;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PlayerStatusManagerServer
extends PlayerStatusManager {
    @Override
    public void tickPlayer(class_1657 player) {
        this.getStatus(player).setTicksToMarkPlayerIdleSyncedForClient(ConfigCommon.ticksToMarkPlayerIdle);
        super.tickPlayer(player);
    }

    public void receiveAny(class_1657 player, class_2487 data) {
        data.method_10582(WatutNetworking.NBTDataPlayerUUID, player.method_5667().toString());
        if (data.method_10545(WatutNetworking.NBTDataPlayerStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.method_10550(WatutNetworking.NBTDataPlayerStatus));
            this.getStatus(player).setPlayerGuiState(playerGuiState);
        }
        if (data.method_10545(WatutNetworking.NBTDataPlayerIdleTicks)) {
            this.handleIdleState(player, data.method_10550(WatutNetworking.NBTDataPlayerIdleTicks));
            data.method_10569(WatutNetworking.NBTDataPlayerTicksToGoIdle, ConfigCommon.ticksToMarkPlayerIdle);
        }
        if (data.method_10545(WatutNetworking.NBTDataPlayerMouseX)) {
            float x = data.method_10583(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.method_10583(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.method_10577(WatutNetworking.NBTDataPlayerMousePressed);
            this.setMouse(player.method_5667(), x, y, pressed);
        }
        this.getStatus(player).getNbtCache().method_10543(data);
        if (data.method_10545(WatutNetworking.NBTDataPlayerStatus) || data.method_10545(WatutNetworking.NBTDataPlayerIdleTicks)) {
            WatutNetworking.instance().serverSendToClientAll(data);
        } else {
            WatutNetworking.instance().serverSendToClientNear(data, player.method_19538(), this.nearbyPlayerDataSendDist, player.method_37908());
        }
    }

    public void handleIdleState(class_1657 player, int idleTicks) {
        PlayerStatus status = this.getStatus(player);
        if (WatutMod.instance().getPlayerList().method_14574() > 1 || this.singleplayerTesting) {
            if (idleTicks > ConfigCommon.ticksToMarkPlayerIdle) {
                if (!status.isIdle()) {
                    this.broadcast(player.method_5476().getString() + " has gone idle");
                }
            } else if (status.isIdle()) {
                this.broadcast(player.method_5476().getString() + " is no longer idle");
            }
        }
        status.setTicksSinceLastAction(idleTicks);
    }

    public void broadcast(String msg) {
        if (ConfigCommon.announceIdleStatesInChat) {
            WatutMod.instance().getPlayerList().method_43514((class_2561)class_2561.method_43470((String)msg), false);
        }
    }

    @Override
    public void playerLoggedIn(class_1657 player) {
        super.playerLoggedIn(player);
        WatutMod.dbg("player logged in");
        if (player instanceof class_3222) {
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("sending update all packet for " + ((UUID)entry.getKey()).toString() + " to " + player.method_5476().getString() + " with status " + PlayerStatus.PlayerGuiState.get(((PlayerStatus)entry.getValue()).getNbtCache().method_10550(WatutNetworking.NBTDataPlayerStatus)));
                WatutNetworking.instance().serverSendToClientPlayer(((PlayerStatus)entry.getValue()).getNbtCache(), player);
            }
        }
    }
}

