/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.screen;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.block.entity.IWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.compat.CompatibleManager;
import ad_astra_giselle_addon.common.network.AddonNetwork;
import ad_astra_giselle_addon.common.network.WorkingAreaVisibleMessage;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.ad_astra.client.screen.AbstractMachineScreen;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.screen.menu.AbstractMachineMenu;
import java.text.NumberFormat;
import net.minecraft.class_1661;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public abstract class AddonMachineScreen<BLOCK_ENTITY extends AbstractMachineBlockEntity, MENU extends AbstractMachineMenu<BLOCK_ENTITY>>
extends AbstractMachineScreen<BLOCK_ENTITY, MENU> {
    public static final String WORKINGAREA_TEXT_PREFIX = AddonMachineScreen.ctl("workingarea.");
    public static final String WORKINGAREA_TEXT_KEY = WORKINGAREA_TEXT_PREFIX + "text";
    public static final class_2960 WORKINGAREA_MIDDLE_TEXTURE = AdAstraGiselleAddon.rl("textures/gui/workingarea_middle.png");
    public static final class_2960 WORKINGAREA_SIDE_TEXTURE = AdAstraGiselleAddon.rl("textures/gui/workingarea_side.png");
    private boolean cachedWorkingAreaVisible;
    private class_4185 workingAreaVisibleButton;

    public static String ctl(String path) {
        return AdAstraGiselleAddon.tl("gui", path);
    }

    public static boolean shouldShowRecipeTooltip() {
        return !CompatibleManager.JEI.isLoaded() && !CompatibleManager.REI.isLoaded();
    }

    public AddonMachineScreen(MENU handler, class_1661 inventory, class_2561 title, class_2960 texture) {
        super(handler, inventory, title, texture);
    }

    protected void method_25426() {
        super.method_25426();
        if (this.hasWorkingArea()) {
            boolean visible;
            this.workingAreaVisibleButton = (class_4185)this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43473(), this::onChangeModeButtonClick).method_46434(this.field_2776, this.field_2800 - 20, 20, 20).method_46431());
            this.cachedWorkingAreaVisible = visible = this.isWorkingAreaVisible();
            this.setWorkingAreaVisible(visible);
            this.refreshWorkingAreaVisibleButtonMessage();
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.updateWorkingAreaVisibleButton();
    }

    public void resizeWorkingAreaVisibleButton() {
        class_4185 workingAreaVisibleButton = this.getWorkingAreaVisibleButton();
        int messageWidth = workingAreaVisibleButton.method_25364();
        messageWidth = Math.max(messageWidth, this.field_22793.method_27525((class_5348)this.getWorkingAreaVisibleText(true)));
        messageWidth = Math.max(messageWidth, this.field_22793.method_27525((class_5348)this.getWorkingAreaVisibleText(false)));
        workingAreaVisibleButton.method_25358(messageWidth + 8);
    }

    public boolean hasWorkingArea() {
        return ((AbstractMachineMenu)this.method_17577()).getMachine() instanceof IWorkingAreaBlockEntity;
    }

    public boolean isWorkingAreaVisible() {
        IWorkingAreaBlockEntity blockEntity;
        AbstractMachineBlockEntity abstractMachineBlockEntity = ((AbstractMachineMenu)this.method_17577()).getMachine();
        return abstractMachineBlockEntity instanceof IWorkingAreaBlockEntity && (blockEntity = (IWorkingAreaBlockEntity)abstractMachineBlockEntity).isWorkingAreaVisible();
    }

    @Nullable
    public class_238 getWorkingArea() {
        AbstractMachineBlockEntity abstractMachineBlockEntity = ((AbstractMachineMenu)this.method_17577()).getMachine();
        if (abstractMachineBlockEntity instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)abstractMachineBlockEntity;
            return blockEntity.getWorkingArea();
        }
        return null;
    }

    public void setWorkingAreaVisible(boolean visible) {
        AbstractMachineBlockEntity machine = ((AbstractMachineMenu)this.method_17577()).getMachine();
        if (machine instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)machine;
            blockEntity.setWorkingAreaVisible(visible);
            AddonNetwork.CHANNEL.sendToServer((Packet)new WorkingAreaVisibleMessage(machine.method_11016(), visible));
        }
    }

    public void onChangeModeButtonClick(class_4185 button) {
        this.setWorkingAreaVisible(!this.isWorkingAreaVisible());
    }

    public void updateWorkingAreaVisibleButton() {
        boolean next = this.isWorkingAreaVisible();
        if (this.cachedWorkingAreaVisible != next) {
            this.cachedWorkingAreaVisible = next;
            this.refreshWorkingAreaVisibleButtonMessage();
        }
    }

    public void refreshWorkingAreaVisibleButtonMessage() {
        class_2561 message = this.getWorkingAreaVisibleText(this.cachedWorkingAreaVisible);
        this.getWorkingAreaVisibleButton().method_25355(message);
        this.resizeWorkingAreaVisibleButton();
    }

    public class_4185 getWorkingAreaVisibleButton() {
        return this.workingAreaVisibleButton;
    }

    protected void drawWorkingAreaText(class_332 guiGraphics, @Nullable class_238 workingArea, class_339 left) {
        if (workingArea == null) {
            return;
        }
        class_2561 workingAreaText = this.getWorkingAreaBoundsText(workingArea);
        int sideWidth = 1;
        int sidePadding = 2;
        int workingAreaWidth = this.field_22793.method_27525((class_5348)workingAreaText) + sidePadding * 2;
        int workingAreaHeight = 11;
        int workingAreaLeft = left.method_46426() + left.method_25368() - this.field_2776;
        int workignAreaTop = -workingAreaHeight;
        int workingAreaOffsetX = workingAreaLeft;
        guiGraphics.method_25290(WORKINGAREA_SIDE_TEXTURE, workingAreaOffsetX, workignAreaTop, 0.0f, 0.0f, sideWidth, workingAreaHeight, sideWidth, workingAreaHeight);
        guiGraphics.method_25290(WORKINGAREA_MIDDLE_TEXTURE, workingAreaOffsetX += sideWidth, workignAreaTop, 0.0f, 0.0f, workingAreaWidth, workingAreaHeight, workingAreaWidth, workingAreaHeight);
        guiGraphics.method_25290(WORKINGAREA_SIDE_TEXTURE, workingAreaOffsetX += workingAreaWidth, workignAreaTop, 0.0f, 0.0f, sideWidth, workingAreaHeight, sideWidth, workingAreaHeight);
        workingAreaOffsetX += sideWidth;
        guiGraphics.method_27535(this.field_22793, workingAreaText, workingAreaLeft + sideWidth + sidePadding, workignAreaTop + 2, 0x303030);
    }

    protected class_2561 getWorkingAreaBoundsText(class_238 workingArea) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        class_5250 workingAreaText = class_2561.method_43469((String)WORKINGAREA_TEXT_KEY, (Object[])new Object[]{numberInstance.format(workingArea.method_17939()), numberInstance.format(workingArea.method_17940()), numberInstance.format(workingArea.method_17941())});
        return workingAreaText;
    }

    protected class_2561 getWorkingAreaVisibleText(boolean visible) {
        String method = visible ? "hide" : "show";
        return class_2561.method_43471((String)(WORKINGAREA_TEXT_PREFIX + method));
    }
}

