/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.config;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.Platform;
import com.bawnorton.neruina.config.Config;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final Path configPath = Platform.getConfigDir().resolve("neruina.json");

    public static void loadConfig() {
        Config config = ConfigManager.load();
        if (config.broadcastErrors == null) {
            config.broadcastErrors = true;
        }
        if (config.handleTickingEntities == null) {
            config.handleTickingEntities = true;
        }
        if (config.handleTickingBlockEntities == null) {
            config.handleTickingBlockEntities = true;
        }
        if (config.handleTickingBlockStates == null) {
            config.handleTickingBlockStates = true;
        }
        if (config.handleTickingItemStacks == null) {
            config.handleTickingItemStacks = true;
        }
        if (config.handleTickingPlayers == null) {
            config.handleTickingPlayers = true;
        }
        Config.update(config);
        ConfigManager.saveConfig();
    }

    private static Config load() {
        Config config = Config.getInstance();
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.createFile(configPath, new FileAttribute[0]);
                return config;
            }
            try {
                config = (Config)GSON.fromJson((Reader)Files.newBufferedReader(configPath), Config.class);
            }
            catch (JsonSyntaxException e) {
                Neruina.LOGGER.error("Failed to parse config file, using default config");
                config = new Config();
            }
        }
        catch (IOException e) {
            Neruina.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return config;
    }

    private static void save() {
        try {
            Files.write(configPath, GSON.toJson((Object)Config.getInstance()).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Neruina.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void saveConfig() {
        ConfigManager.save();
        Neruina.LOGGER.debug("Saved client config");
    }
}

