/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Skill;

public class Category {
    private final class_2960 categoryId;

    public Category(class_2960 categoryId) {
        this.categoryId = categoryId;
    }

    public class_2960 getId() {
        return this.categoryId;
    }

    public Optional<Skill> getSkill(String skillId) {
        if (SkillsMod.getInstance().hasSkill(this.categoryId, skillId)) {
            return Optional.of(new Skill(this, skillId));
        }
        return Optional.empty();
    }

    private List<Skill> getSkills() {
        return SkillsMod.getInstance().getSkills(this.categoryId).orElseThrow().stream().map(skillId -> new Skill(this, (String)skillId)).toList();
    }

    public Collection<Skill> getUnlockedSkills(class_3222 player) {
        return SkillsMod.getInstance().getUnlockedSkills(player, this.categoryId).orElseThrow().stream().map(skillId -> new Skill(this, (String)skillId)).toList();
    }

    public void unlock(class_3222 player) {
        SkillsMod.getInstance().unlockCategory(player, this.categoryId);
    }

    public void lock(class_3222 player) {
        SkillsMod.getInstance().lockCategory(player, this.categoryId);
    }

    public void erase(class_3222 player) {
        SkillsMod.getInstance().eraseCategory(player, this.categoryId);
    }

    public void resetSkills(class_3222 player) {
        SkillsMod.getInstance().resetSkills(player, this.categoryId);
    }

    public int getExperience(class_3222 player) {
        return SkillsMod.getInstance().getExperience(player, this.categoryId).orElseThrow();
    }

    public void setExperience(class_3222 player, int amount) {
        SkillsMod.getInstance().setExperience(player, this.categoryId, amount);
    }

    public void addExperience(class_3222 player, int amount) {
        SkillsMod.getInstance().addExperience(player, this.categoryId, amount);
    }

    public int getExtraPoints(class_3222 player) {
        return SkillsMod.getInstance().getExtraPoints(player, this.categoryId).orElseThrow();
    }

    public void setExtraPoints(class_3222 player, int count) {
        SkillsMod.getInstance().setExtraPoints(player, this.categoryId, count);
    }

    public void addExtraPoints(class_3222 player, int count) {
        SkillsMod.getInstance().addExtraPoints(player, this.categoryId, count);
    }

    public int getPointsLeft(class_3222 player) {
        return SkillsMod.getInstance().getPointsLeft(player, this.categoryId).orElseThrow();
    }

    public int getCurrentLevel(class_3222 player) {
        return SkillsMod.getInstance().getCurrentLevel(player, this.categoryId).orElseThrow();
    }

    public int getCurrentExperience(class_3222 player) {
        return SkillsMod.getInstance().getCurrentExperience(player, this.categoryId).orElseThrow();
    }

    public int getRequiredExperience(class_3222 player) {
        return SkillsMod.getInstance().getRequiredExperience(player, this.categoryId).orElseThrow();
    }
}

