/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.experience.ExperienceSourceWithDataFactory;
import net.puffish.skillsmod.api.experience.ExperienceSourceWithoutDataFactory;
import net.puffish.skillsmod.api.rewards.RewardWithDataFactory;
import net.puffish.skillsmod.api.rewards.RewardWithoutDataFactory;
import net.puffish.skillsmod.experience.ExperienceSourceRegistry;
import net.puffish.skillsmod.rewards.RewardRegistry;

public class SkillsAPI {
    public static final String MOD_ID = "puffish_skills";

    public static void registerRewardWithData(class_2960 key, RewardWithDataFactory factory) {
        RewardRegistry.register(key, factory);
    }

    public static void registerRewardWithoutData(class_2960 key, RewardWithoutDataFactory factory) {
        RewardRegistry.register(key, factory);
    }

    public static void refreshReward(class_3222 player, class_2960 key) {
        SkillsMod.getInstance().refreshReward(player, key);
    }

    public static void registerExperienceSourceWithData(class_2960 key, ExperienceSourceWithDataFactory factory) {
        ExperienceSourceRegistry.register(key, factory);
    }

    public static void registerExperienceSourceWithoutData(class_2960 key, ExperienceSourceWithoutDataFactory factory) {
        ExperienceSourceRegistry.register(key, factory);
    }

    public static void visitExperienceSources(class_3222 player, Function<ExperienceSource, Integer> function) {
        SkillsMod.getInstance().visitExperienceSources(player, function);
    }

    public static Optional<Category> getCategory(class_2960 categoryId) {
        if (SkillsMod.getInstance().hasCategory(categoryId)) {
            return Optional.of(new Category(categoryId));
        }
        return Optional.empty();
    }

    public static List<Category> getCategories() {
        return SkillsMod.getInstance().getCategories().stream().map(Category::new).toList();
    }

    public static List<Category> getUnlockedCategories(class_3222 player) {
        return SkillsMod.getInstance().getUnlockedCategories(player).stream().map(Category::new).toList();
    }
}

