/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class DamageTypeCondition
implements Condition<class_6880<class_8110>> {
    private final class_8110 damageType;

    private DamageTypeCondition(class_8110 damageType) {
        this.damageType = damageType;
    }

    public static ConditionFactory<class_6880<class_8110>> factory() {
        return ConditionFactory.withData(DamageTypeCondition::parse);
    }

    public static Result<DamageTypeCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> DamageTypeCondition.parse(rootObject, context));
    }

    public static Result<DamageTypeCondition, Failure> parse(JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optDamage = rootObject.get("damage").andThen(damageElement -> JsonParseUtils.parseDamageType(damageElement, context.getDynamicRegistryManager())).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new DamageTypeCondition((class_8110)optDamage.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(class_6880<class_8110> damageType) {
        return this.damageType == damageType.comp_349();
    }
}

