/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1299;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class EntityTypeCondition
implements Condition<class_1299<?>> {
    private final class_1299<?> entityType;

    private EntityTypeCondition(class_1299<?> entityType) {
        this.entityType = entityType;
    }

    public static ConditionFactory<class_1299<?>> factory() {
        return ConditionFactory.withData(EntityTypeCondition::parse);
    }

    public static Result<EntityTypeCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(EntityTypeCondition::parse);
    }

    public static Result<EntityTypeCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optEntity = rootObject.get("entity").andThen(JsonParseUtils::parseEntityType).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new EntityTypeCondition((class_1299)optEntity.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(class_1299<?> entityType) {
        return this.entityType == entityType;
    }
}

