/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2105;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class ItemCondition
implements Condition<class_1799> {
    private final class_1792 item;
    private final Optional<class_2105> optNbt;

    public ItemCondition(class_1792 item, Optional<class_2105> optNbt) {
        this.item = item;
        this.optNbt = optNbt;
    }

    public static ConditionFactory<class_1799> factory() {
        return ConditionFactory.withData(ItemCondition::parse);
    }

    public static Result<ItemCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(ItemCondition::parse);
    }

    public static Result<ItemCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optItem = rootObject.get("item").andThen(JsonParseUtils::parseItem).ifFailure(failures::add).getSuccess();
        Optional<class_2105> optNbt = rootObject.get("nbt").getSuccess().flatMap(stateElement -> JsonParseUtils.parseNbtPredicate(stateElement).ifFailure(failures::add).getSuccess());
        if (failures.isEmpty()) {
            return Result.success(new ItemCondition((class_1792)optItem.orElseThrow(), optNbt));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return itemStack.method_31574(this.item) && this.optNbt.map((? super T nbt) -> nbt.method_9074(itemStack)).orElse(true) != false;
    }
}

