/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.parameter;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.parameter.ParameterFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.experience.calculation.parameter.FallbackParameter;

public interface Parameter<T>
extends Function<T, Double> {
    default public <R> Parameter<R> map(Function<R, T> function) {
        return r -> (Double)this.apply(function.apply(r));
    }

    public static <T> Result<Parameter<T>, Failure> parse(JsonElementWrapper rootElement, Map<String, ParameterFactory<T>> factories, ConfigContext context) {
        return rootElement.getAsObject().andThen((S rootObject) -> Parameter.parse(rootObject, factories, context));
    }

    public static <T> Result<Parameter<T>, Failure> parse(JsonObjectWrapper rootObject, Map<String, ParameterFactory<T>> factories, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<String> optType = rootObject.getString("type").ifFailure(failures::add).getSuccess();
        Result<JsonElementWrapper, Failure> maybeDataElement = rootObject.get("data");
        Optional optFallback = rootObject.get("fallback").getSuccess().flatMap(fallbackElement -> fallbackElement.getAsDouble().ifFailure(failures::add).getSuccess());
        if (failures.isEmpty()) {
            return Parameter.build(optType.orElseThrow(), maybeDataElement, rootObject.getPath().thenObject("type"), factories, context).orElse(failure -> {
                if (optFallback.isPresent()) {
                    context.addWarning((Failure)failure);
                    return Result.success(new FallbackParameter((Double)optFallback.orElseThrow()));
                }
                return Result.failure(failure);
            });
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    private static <T> Result<Parameter<T>, Failure> build(String type, Result<JsonElementWrapper, Failure> maybeDataElement, JsonPath typePath, Map<String, ParameterFactory<T>> factories, ConfigContext context) {
        ParameterFactory<Result<JsonElementWrapper, Failure>> factory = factories.get(type);
        if (factory == null) {
            return Result.failure(typePath.failureAt("Expected a valid parameter type"));
        }
        return ((Result)factory.apply(maybeDataElement, context)).mapSuccess(c -> c);
    }
}

