/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.puffish.skillsmod.api.json.JsonArrayWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.json.JsonWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;

public class JsonElementWrapper
extends JsonWrapper {
    private final JsonElement json;

    public JsonElementWrapper(JsonElement json, JsonPath path) {
        super(path);
        this.json = json;
    }

    public static Result<JsonElementWrapper, Failure> parseString(String jsonData, JsonPath jsonPath) {
        try {
            return Result.success(new JsonElementWrapper(JsonParser.parseString((String)jsonData), jsonPath));
        }
        catch (Exception e) {
            return Result.failure(jsonPath.failureAt("Could not read JSON"));
        }
    }

    public static Result<JsonElementWrapper, Failure> parseReader(Reader reader, JsonPath jsonPath) {
        try {
            return Result.success(new JsonElementWrapper(JsonParser.parseReader((Reader)reader), jsonPath));
        }
        catch (Exception e) {
            return Result.failure(jsonPath.failureAt("Could not read JSON"));
        }
    }

    public static Result<JsonElementWrapper, Failure> parseFile(Path filePath, JsonPath jsonPath) {
        try {
            String content = Files.readString(filePath);
            if (content.isEmpty()) {
                return Result.failure(jsonPath.failureAt("File is empty"));
            }
            return Result.success(new JsonElementWrapper(JsonParser.parseString((String)content), jsonPath));
        }
        catch (Exception e) {
            return Result.failure(jsonPath.failureAt("Could not read JSON"));
        }
    }

    public Result<JsonObjectWrapper, Failure> getAsObject() {
        try {
            return Result.success(new JsonObjectWrapper(this.json.getAsJsonObject(), this.path));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an object"));
        }
    }

    public Result<JsonArrayWrapper, Failure> getAsArray() {
        try {
            return Result.success(new JsonArrayWrapper(this.json.getAsJsonArray(), this.path));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an array"));
        }
    }

    public Result<String, Failure> getAsString() {
        try {
            return Result.success(this.json.getAsString());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a string"));
        }
    }

    public Result<Float, Failure> getAsFloat() {
        try {
            return Result.success(Float.valueOf(this.json.getAsFloat()));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a float"));
        }
    }

    public Result<Double, Failure> getAsDouble() {
        try {
            return Result.success(this.json.getAsDouble());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a double"));
        }
    }

    public Result<Integer, Failure> getAsInt() {
        try {
            return Result.success(this.json.getAsInt());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an int"));
        }
    }

    public Result<Boolean, Failure> getAsBoolean() {
        try {
            return Result.success(this.json.getAsBoolean());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a boolean"));
        }
    }

    public JsonElement getJson() {
        return this.json;
    }
}

