/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import net.minecraft.class_1060;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClientIconData {

    public static class TextureIconData
    implements ClientIconData {
        private final class_2960 texture;

        private TextureIconData(class_2960 texture) {
            this.texture = texture;
        }

        public static Result<TextureIconData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("texture")).andThen(JsonParseUtils::parseIdentifier).mapSuccess(TextureIconData::new);
        }

        public static TextureIconData createMissing() {
            return new TextureIconData(class_1060.field_5285);
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static class EffectIconData
    implements ClientIconData {
        private final class_1291 effect;

        private EffectIconData(class_1291 effect) {
            this.effect = effect;
        }

        public static Result<EffectIconData, Failure> parse(JsonElementWrapper rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("effect")).andThen(JsonParseUtils::parseEffect).mapSuccess(EffectIconData::new);
        }

        public class_1291 getEffect() {
            return this.effect;
        }
    }

    public static class ItemIconData
    implements ClientIconData {
        private final class_1799 item;

        private ItemIconData(class_1799 item) {
            this.item = item;
        }

        public static Result<ItemIconData, Failure> parse(JsonElementWrapper rootElement) {
            return JsonParseUtils.parseItemStack(rootElement).mapSuccess(ItemIconData::new);
        }

        public class_1799 getItem() {
            return this.item;
        }
    }
}

