/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import org.joml.Vector2i;

public class ClientSkillCategoryData {
    private final class_2960 id;
    private final class_2561 title;
    private final ClientIconData icon;
    private final class_2960 background;
    private final boolean exclusiveRoot;
    private final int spentPointsLimit;
    private final Map<String, ClientSkillDefinitionData> definitions;
    private final Map<String, ClientSkillData> skills;
    private final Collection<ClientSkillConnectionData> normalConnections;
    private final Map<String, Collection<String>> normalNeighbors;
    private final Map<String, Collection<String>> exclusiveNeighbors;
    private final Map<String, Collection<ClientSkillConnectionData>> exclusiveConnections;
    private int spentPoints;
    private int earnedPoints;
    private int currentLevel;
    private int currentExperience;
    private int requiredExperience;

    public ClientSkillCategoryData(class_2960 id, class_2561 title, ClientIconData icon, class_2960 background, boolean exclusiveRoot, int spentPointsLimit, Map<String, ClientSkillDefinitionData> definitions, Map<String, ClientSkillData> skills, Collection<ClientSkillConnectionData> normalConnections, Collection<ClientSkillConnectionData> exclusiveConnections, int spentPoints, int earnedPoints, int currentLevel, int currentExperience, int requiredExperience) {
        String b;
        String a;
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.background = background;
        this.exclusiveRoot = exclusiveRoot;
        this.spentPointsLimit = spentPointsLimit;
        this.definitions = definitions;
        this.skills = skills;
        this.normalConnections = normalConnections;
        this.spentPoints = spentPoints;
        this.earnedPoints = earnedPoints;
        this.currentLevel = currentLevel;
        this.currentExperience = currentExperience;
        this.requiredExperience = requiredExperience;
        this.normalNeighbors = new HashMap<String, Collection<String>>();
        this.exclusiveNeighbors = new HashMap<String, Collection<String>>();
        this.exclusiveConnections = new HashMap<String, Collection<ClientSkillConnectionData>>();
        for (ClientSkillConnectionData connection : normalConnections) {
            a = connection.getSkillAId();
            b = connection.getSkillBId();
            this.normalNeighbors.computeIfAbsent(a, key -> new HashSet()).add(b);
            if (!connection.isBidirectional()) continue;
            this.normalNeighbors.computeIfAbsent(b, key -> new HashSet()).add(a);
        }
        for (ClientSkillConnectionData connection : exclusiveConnections) {
            a = connection.getSkillAId();
            b = connection.getSkillBId();
            this.exclusiveNeighbors.computeIfAbsent(a, key -> new HashSet()).add(b);
            if (connection.isBidirectional()) {
                this.exclusiveNeighbors.computeIfAbsent(b, key -> new HashSet()).add(a);
            }
            this.exclusiveConnections.computeIfAbsent(a, key -> new HashSet()).add(connection);
            this.exclusiveConnections.computeIfAbsent(b, key -> new HashSet()).add(connection);
        }
    }

    public Bounds2i getBounds() {
        Bounds2i bounds = Bounds2i.zero();
        for (ClientSkillData skill : this.skills.values()) {
            bounds.extend(new Vector2i(skill.getX(), skill.getY()));
        }
        return bounds;
    }

    public void unlock(String skillId) {
        Collection<String> collection;
        Collection<String> normalNeighborsIds;
        ClientSkillData skill = this.skills.get(skillId);
        if (skill == null) {
            return;
        }
        skill.setState(SkillState.UNLOCKED);
        if (skill.isRoot() && this.exclusiveRoot) {
            for (ClientSkillData clientSkillData : this.skills.values()) {
                if (!clientSkillData.isRoot() || clientSkillData.getState() != SkillState.AVAILABLE) continue;
                clientSkillData.setState(SkillState.LOCKED);
            }
        }
        if ((normalNeighborsIds = this.normalNeighbors.get(skillId)) != null) {
            for (String neighborId : normalNeighborsIds) {
                ClientSkillData neighbor = this.skills.get(neighborId);
                if (neighbor == null || neighbor.getState() != SkillState.LOCKED) continue;
                neighbor.setState(SkillState.AVAILABLE);
            }
        }
        if ((collection = this.exclusiveNeighbors.get(skillId)) != null) {
            for (String neighborId : collection) {
                ClientSkillData neighbor = this.skills.get(neighborId);
                if (neighbor == null || neighbor.getState() == SkillState.UNLOCKED) continue;
                neighbor.setState(SkillState.EXCLUDED);
            }
        }
    }

    public boolean hasAvailableSkill() {
        return this.skills.values().stream().anyMatch(skill -> skill.getState() == SkillState.AVAILABLE);
    }

    public class_2960 getId() {
        return this.id;
    }

    public Map<String, ClientSkillDefinitionData> getDefinitions() {
        return this.definitions;
    }

    public Map<String, ClientSkillData> getSkills() {
        return this.skills;
    }

    public Collection<ClientSkillConnectionData> getNormalConnections() {
        return this.normalConnections;
    }

    public Map<String, Collection<ClientSkillConnectionData>> getExclusiveConnections() {
        return this.exclusiveConnections;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public ClientIconData getIcon() {
        return this.icon;
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public int getPointsLeft() {
        return Math.max(Math.min(this.earnedPoints, this.spentPointsLimit) - this.spentPoints, 0);
    }

    public int getSpentPoints() {
        return this.spentPoints;
    }

    public void setSpentPoints(int spentPoints) {
        this.spentPoints = spentPoints;
    }

    public int getEarnedPoints() {
        return this.earnedPoints;
    }

    public void setEarnedPoints(int earnedPoints) {
        this.earnedPoints = earnedPoints;
    }

    public int getSpentPointsLeft() {
        return Math.max(this.spentPointsLimit - this.spentPoints, 0);
    }

    public int getSpentPointsLimit() {
        return this.spentPointsLimit;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public int getCurrentExperience() {
        return this.currentExperience;
    }

    public void setCurrentExperience(int currentExperience) {
        this.currentExperience = currentExperience;
    }

    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public void setRequiredExperience(int requiredExperience) {
        this.requiredExperience = requiredExperience;
    }

    public float getExperienceProgress() {
        return (float)this.currentExperience / (float)this.requiredExperience;
    }

    public int getExperienceToNextLevel() {
        return this.requiredExperience - this.currentExperience;
    }
}

