/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_455;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.data.ClientFrameData;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;

public class SkillsScreen
extends class_437 {
    private static final class_2960 TABS_TEXTURE = new class_2960("textures/gui/advancements/tabs.png");
    private static final class_2960 WINDOW_TEXTURE = new class_2960("textures/gui/advancements/window.png");
    private static final class_2960 WIDGETS_TEXTURE = new class_2960("textures/gui/advancements/widgets.png");
    private static final class_2960 ICONS_TEXTURE = new class_2960("textures/gui/icons.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private final List<ClientSkillCategoryData> categories;
    private int activeCategory = 0;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private float scale = 1.0f;
    private int x = 0;
    private int y = 0;
    private boolean dragging;
    private Bounds2i bounds;
    private double dragStartX;
    private double dragStartY;
    private boolean small;
    private int contentPaddingTop;
    private int contentPaddingLeft;
    private int contentPaddingRight;
    private int contentPaddingBottom;

    public SkillsScreen(List<ClientSkillCategoryData> categories) {
        super(class_5244.field_39003);
        this.categories = categories;
    }

    private ClientSkillCategoryData getActiveCategory() {
        return this.categories.get(this.activeCategory);
    }

    private void setActiveCategory(int activeCategory) {
        this.activeCategory = activeCategory;
        this.resize();
    }

    protected void method_25426() {
        super.method_25426();
        this.resize();
    }

    private void resize() {
        boolean bl = this.small = this.field_22789 < 450;
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        this.x = this.field_22789 / 2;
        this.y = this.field_22790 / 2;
        this.bounds = this.getActiveCategory().getBounds();
        this.bounds.grow(32);
        this.bounds.extend(new Vector2i(this.contentPaddingLeft - this.x, this.contentPaddingTop - this.y));
        this.bounds.extend(new Vector2i(this.field_22789 - this.x - this.contentPaddingRight, this.field_22790 - this.y - this.contentPaddingBottom));
        int contentWidth = this.field_22789 - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.field_22790 - this.contentPaddingTop - this.contentPaddingBottom;
        int halfWidth = class_3532.method_38788((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
        int halfHeight = class_3532.method_38788((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
        this.bounds.extend(new Vector2i(-halfWidth, -halfHeight));
        this.bounds.extend(new Vector2i(halfWidth, halfHeight));
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.scale = 1.0f;
    }

    private Vector2i getMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)mouseX, (int)mouseY);
    }

    private Vector2i getTransformedMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)Math.round((mouseX - (double)this.x) / (double)this.scale), (int)Math.round((mouseY - (double)this.y) / (double)this.scale));
    }

    private boolean isInsideTab(Vector2i mouse, int i) {
        return mouse.x >= 8 + i * 32 && mouse.y >= 8 && mouse.x < 8 + i * 32 + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vector2i transformedMouse, ClientSkillData skill, ClientSkillDefinitionData definition) {
        int halfSize = Math.round(13.0f * definition.getSize());
        return transformedMouse.x >= skill.getX() - halfSize && transformedMouse.y >= skill.getY() - halfSize && transformedMouse.x < skill.getX() + halfSize && transformedMouse.y < skill.getY() + halfSize;
    }

    private boolean isInsideContent(Vector2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.field_22789 - this.contentPaddingRight && mouse.y < this.field_22790 - this.contentPaddingBottom;
    }

    private boolean isInsideExperience(Vector2i mouse, int x, int y) {
        return mouse.x >= x && mouse.y >= y && mouse.x < x + 182 && mouse.y < y + 5;
    }

    private boolean isInsideArea(Vector2i mouse, int x1, int y1, int x2, int y2) {
        return mouse.x >= x1 && mouse.y >= y1 && mouse.x < x2 && mouse.y < y2;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            for (ClientSkillData skill : this.getActiveCategory().getSkills().values()) {
                ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill.getDefinitionId());
                if (definition == null || !this.isInsideSkill(transformedMouse, skill, definition)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(SkillClickOutPacket.write(this.getActiveCategory().getId(), skill.getId()));
            }
            if (button == 0) {
                this.dragStartX = mouseX - (double)this.x;
                this.dragStartY = mouseY - (double)this.y;
                this.dragging = true;
            }
        } else {
            this.dragging = false;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!this.isInsideTab(mouse, i)) continue;
            this.setActiveCategory(i);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        this.drawContent(context, mouseX, mouseY);
        this.drawWindow(context, mouseX, mouseY);
        this.drawTabs(context, mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.x = (int)Math.round(mouseX - this.dragStartX);
            this.y = (int)Math.round(mouseY - this.dragStartY);
            this.limitPosition();
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        float factor = (float)Math.pow(2.0, amount * 0.25);
        this.scale *= factor;
        if (this.scale < this.minScale) {
            this.scale = this.minScale;
            factor = this.minScale / this.scale;
        }
        if (this.scale > this.maxScale) {
            this.scale = this.maxScale;
            factor = this.maxScale / this.scale;
        }
        this.x -= (int)Math.round((double)(factor - 1.0f) * (mouseX - (double)this.x));
        this.y -= (int)Math.round((double)(factor - 1.0f) * (mouseY - (double)this.y));
        this.limitPosition();
        return super.method_25401(mouseX, mouseY, amount);
    }

    private void limitPosition() {
        this.y = Math.min(this.y, (int)Math.floor((float)this.contentPaddingTop - (float)this.bounds.min().y() * this.scale));
        this.x = Math.min(this.x, (int)Math.floor((float)this.contentPaddingLeft - (float)this.bounds.min().x() * this.scale));
        this.x = Math.max(this.x, (int)Math.ceil((float)(this.field_22789 - this.contentPaddingRight) - (float)this.bounds.max().x() * this.scale));
        this.y = Math.max(this.y, (int)Math.ceil((float)(this.field_22790 - this.contentPaddingBottom) - (float)this.bounds.max().y() * this.scale));
    }

    private void drawIcon(class_332 context, ClientIconData icon, float sizeScale, int x, int y) {
        if (this.field_22787 == null) {
            return;
        }
        if (icon instanceof ClientIconData.ItemIconData) {
            ClientIconData.ItemIconData itemIcon = (ClientIconData.ItemIconData)icon;
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)x * (1.0f - sizeScale), (float)y * (1.0f - sizeScale), 0.0f);
            matrices.method_22905(sizeScale, sizeScale, 1.0f);
            context.method_51427(itemIcon.getItem(), x - 8, y - 8);
            matrices.method_22909();
        } else if (icon instanceof ClientIconData.EffectIconData) {
            ClientIconData.EffectIconData effectIcon = (ClientIconData.EffectIconData)icon;
            class_1058 sprite = this.field_22787.method_18505().method_18663(effectIcon.getEffect());
            int halfSize = Math.round(9.0f * sizeScale);
            int size = halfSize * 2;
            context.method_25298(x - halfSize, y - halfSize, 0, size, size, sprite);
        } else if (icon instanceof ClientIconData.TextureIconData) {
            ClientIconData.TextureIconData textureIcon = (ClientIconData.TextureIconData)icon;
            int halfSize = Math.round(8.0f * sizeScale);
            int size = halfSize * 2;
            context.method_25290(textureIcon.getTexture(), x - halfSize, y - halfSize, 0.0f, 0.0f, size, size, size, size);
        }
    }

    private void drawFrame(class_332 context, ClientFrameData frame, float sizeScale, int x, int y, SkillState state) {
        if (this.field_22787 == null) {
            return;
        }
        int halfSize = Math.round(13.0f * sizeScale);
        int size = halfSize * 2;
        if (frame instanceof ClientFrameData.AdvancementFrameData) {
            ClientFrameData.AdvancementFrameData advancementFrame = (ClientFrameData.AdvancementFrameData)frame;
            class_455 status = state == SkillState.UNLOCKED ? class_455.field_2701 : class_455.field_2699;
            switch (state) {
                case LOCKED: 
                case EXCLUDED: {
                    RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    break;
                }
                default: {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            context.method_25293(WIDGETS_TEXTURE, x - halfSize, y - halfSize, size, size, (float)advancementFrame.getFrame().method_832(), (float)(128 + status.method_2320() * 26), 26, 26, 256, 256);
        } else if (frame instanceof ClientFrameData.TextureFrameData) {
            ClientFrameData.TextureFrameData textureFrame = (ClientFrameData.TextureFrameData)frame;
            class_2960 texture = switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case SkillState.AVAILABLE -> {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    yield textureFrame.getAvailableTexture();
                }
                case SkillState.UNLOCKED -> {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    yield textureFrame.getUnlockedTexture();
                }
                case SkillState.LOCKED -> {
                    if (textureFrame.getLockedTexture() != null) {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        yield textureFrame.getLockedTexture();
                    }
                    RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    yield textureFrame.getAvailableTexture();
                }
                case SkillState.EXCLUDED -> {
                    if (textureFrame.getExcludedTexture() != null) {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        yield textureFrame.getExcludedTexture();
                    }
                    RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    yield textureFrame.getAvailableTexture();
                }
            };
            context.method_25290(texture, x - halfSize, y - halfSize, 0.0f, 0.0f, size, size, size, size);
        }
    }

    private void drawContent(class_332 context, double mouseX, double mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        context.method_44379(this.contentPaddingLeft - 4, this.contentPaddingTop - 4, this.field_22789 - this.contentPaddingRight + 4, this.field_22790 - this.contentPaddingBottom + 4);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
        context.method_51448().method_22905(this.scale, this.scale, 1.0f);
        context.method_25290(this.getActiveCategory().getBackground(), this.bounds.min().x(), this.bounds.min().y(), 0.0f, 0.0f, this.bounds.width(), this.bounds.height(), 16, 16);
        for (ClientSkillConnectionData connection : this.getActiveCategory().getNormalConnections()) {
            ClientSkillData skillA = this.getActiveCategory().getSkills().get(connection.getSkillAId());
            ClientSkillData skillB = this.getActiveCategory().getSkills().get(connection.getSkillBId());
            if (skillA == null || skillB == null) continue;
            this.drawConnection(context, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), !connection.isBidirectional(), 0xFFFFFF);
        }
        if (this.isInsideContent(mouse)) {
            Optional<ClientSkillData> optHoveredSkill = this.getActiveCategory().getSkills().values().stream().filter(skill -> {
                ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill.getDefinitionId());
                if (definition == null) {
                    return false;
                }
                return this.isInsideSkill(transformedMouse, (ClientSkillData)skill, definition);
            }).findFirst();
            optHoveredSkill.ifPresent(hoveredSkill -> {
                ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(hoveredSkill.getDefinitionId());
                if (definition == null) {
                    return;
                }
                ArrayList<class_5481> lines = new ArrayList<class_5481>();
                lines.add(definition.getTitle().method_30937());
                lines.addAll(class_7919.method_47406((class_310)this.field_22787, (class_2561)class_2564.method_10889((class_5250)definition.getDescription().method_27661(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1080))));
                if (class_437.method_25442()) {
                    lines.addAll(class_7919.method_47406((class_310)this.field_22787, (class_2561)class_2564.method_10889((class_5250)definition.getExtraDescription().method_27661(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1080))));
                }
                if (this.field_22787.field_1690.field_1827) {
                    lines.add(class_2561.method_43470((String)hoveredSkill.getId()).method_27692(class_124.field_1063).method_30937());
                }
                this.method_47414(lines);
                Collection<ClientSkillConnectionData> connections = this.getActiveCategory().getExclusiveConnections().get(hoveredSkill.getId());
                if (connections != null) {
                    for (ClientSkillConnectionData connection : connections) {
                        ClientSkillData skillA = this.getActiveCategory().getSkills().get(connection.getSkillAId());
                        ClientSkillData skillB = this.getActiveCategory().getSkills().get(connection.getSkillBId());
                        if (skillA == null || skillB == null) continue;
                        this.drawConnection(context, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), !connection.isBidirectional(), 0xFF0000);
                    }
                }
            });
        }
        for (ClientSkillData skill2 : this.getActiveCategory().getSkills().values()) {
            ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill2.getDefinitionId());
            if (definition == null) continue;
            this.drawFrame(context, definition.getFrame(), definition.getSize(), skill2.getX(), skill2.getY(), skill2.getState());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawIcon(context, definition.getIcon(), definition.getSize(), skill2.getX(), skill2.getY());
        }
        context.method_51448().method_22909();
        context.method_44380();
    }

    private void drawConnection(class_332 context, float startX, float startY, float endX, float endY, boolean unidirectional, int rgb) {
        this.drawLine(context, startX, startY, endX, endY, 3.0f, -16777216);
        if (unidirectional) {
            this.drawArrow(context, startX, startY, endX, endY, 8.0f, -16777216);
        }
        this.drawLine(context, startX, startY, endX, endY, 1.0f, rgb | 0xFF000000);
        if (unidirectional) {
            this.drawArrow(context, startX, startY, endX, endY, 6.0f, rgb | 0xFF000000);
        }
    }

    private void drawLine(class_332 context, float startX, float startY, float endX, float endY, float thickness, int argb) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        Vector2f side = new Vector2f(endX, endY).sub(startX, startY).normalize().perpendicular().mul(thickness / 2.0f);
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        bufferBuilder.method_22918(matrix, startX + side.x, startY + side.y, 0.0f).method_39415(argb).method_1344();
        bufferBuilder.method_22918(matrix, startX - side.x, startY - side.y, 0.0f).method_39415(argb).method_1344();
        bufferBuilder.method_22918(matrix, endX - side.x, endY - side.y, 0.0f).method_39415(argb).method_1344();
        bufferBuilder.method_22918(matrix, endX + side.x, endY + side.y, 0.0f).method_39415(argb).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private void drawArrow(class_332 context, float startX, float startY, float endX, float endY, float thickness, int argb) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        Vector2f center = new Vector2f(endX, endY).add(startX, startY).div(2.0f);
        Vector2f normal = new Vector2f(endX, endY).sub(startX, startY).normalize();
        Vector2f forward = new Vector2f((Vector2fc)normal).mul(thickness);
        Vector2f backward = new Vector2f((Vector2fc)forward).div(-2.0f);
        Vector2f back = new Vector2f((Vector2fc)center).add((Vector2fc)backward);
        Vector2f side = new Vector2f((Vector2fc)backward).perpendicular().mul(class_3532.method_15355((float)3.0f));
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        bufferBuilder.method_22918(matrix, center.x + forward.x, center.y + forward.y, 0.0f).method_39415(argb).method_1344();
        bufferBuilder.method_22918(matrix, back.x - side.x, back.y - side.y, 0.0f).method_39415(argb).method_1344();
        bufferBuilder.method_22918(matrix, back.x + side.x, back.y + side.y, 0.0f).method_39415(argb).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private void drawTabs(class_332 context, double mouseX, double mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        for (int i = 0; i < this.categories.size(); ++i) {
            context.method_25302(TABS_TEXTURE, 8 + 32 * i, 8, i > 0 ? 28 : 0, this.activeCategory == i ? 32 : 0, 28, 32);
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        for (int i = 0; i < this.categories.size(); ++i) {
            ClientSkillCategoryData category = this.categories.get(i);
            this.drawIcon(context, category.getIcon(), 1.0f, 8 + 32 * i + 6 + 8, 25);
            if (!this.isInsideTab(mouse, i)) continue;
            this.method_47414(class_7919.method_47406((class_310)this.field_22787, (class_2561)category.getTitle()));
        }
    }

    private void drawWindow(class_332 context, double mouseX, double mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        context.method_25290(WINDOW_TEXTURE, 8, this.field_22790 - 8 - 70 + 1, 0.0f, 70.0f, 126, 70, 256, 256);
        context.method_25290(WINDOW_TEXTURE, this.field_22789 - 8 - 126 + 1, this.field_22790 - 8 - 70 + 1, 126.0f, 70.0f, 126, 70, 256, 256);
        context.method_25293(WINDOW_TEXTURE, 8, 78, 126, this.field_22790 - 16 - 140 + 1, 0.0f, 69.0f, 126, 2, 256, 256);
        context.method_25293(WINDOW_TEXTURE, 134, this.field_22790 - 8 - 70 + 1, this.field_22789 - 16 - 252 + 1, 70, 125.0f, 70.0f, 2, 70, 256, 256);
        context.method_25293(WINDOW_TEXTURE, this.field_22789 - 8 - 126 + 1, 78, 126, this.field_22790 - 16 - 140 + 1, 126.0f, 69.0f, 126, 2, 256, 256);
        if (this.small) {
            context.method_25290(WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 16, 256, 256);
            context.method_25290(WINDOW_TEXTURE, 8, 52, 0.0f, 8.0f, 126, 26, 256, 256);
            context.method_25290(WINDOW_TEXTURE, this.field_22789 - 8 - 126 + 1, 36, 126.0f, 0.0f, 126, 16, 256, 256);
            context.method_25290(WINDOW_TEXTURE, this.field_22789 - 8 - 126 + 1, 52, 126.0f, 8.0f, 126, 26, 256, 256);
            context.method_25293(WINDOW_TEXTURE, 134, 36, this.field_22789 - 16 - 252 + 1, 16, 125.0f, 0.0f, 2, 16, 256, 256);
            context.method_25293(WINDOW_TEXTURE, 134, 52, this.field_22789 - 16 - 252 + 1, 54, 125.0f, 8.0f, 2, 54, 256, 256);
        } else {
            context.method_25290(WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 42, 256, 256);
            context.method_25290(WINDOW_TEXTURE, this.field_22789 - 8 - 126 + 1, 36, 126.0f, 0.0f, 126, 42, 256, 256);
            context.method_25293(WINDOW_TEXTURE, 134, 36, this.field_22789 - 16 - 252 + 1, 70, 125.0f, 0.0f, 2, 70, 256, 256);
        }
        class_5250 tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX, tmpY, -12566464, false);
        int leftX = tmpX + this.field_22793.method_27525((class_5348)tmpText);
        int startX = tmpX = this.field_22789 - 8 - 7;
        ClientSkillCategoryData activeCategory = this.getActiveCategory();
        tmpText = class_2561.method_43470((String)(activeCategory.getPointsLeft() + (String)(activeCategory.getSpentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.getSpentPointsLeft())));
        tmpX -= this.field_22793.method_27525((class_5348)tmpText);
        class_327 textRenderer = class_310.method_1551().field_1772;
        context.method_51439(textRenderer, (class_2561)tmpText, --tmpX - 1, tmpY, -16777216, false);
        context.method_51439(textRenderer, (class_2561)tmpText, tmpX, tmpY - 1, -16777216, false);
        context.method_51439(textRenderer, (class_2561)tmpText, tmpX + 1, tmpY, -16777216, false);
        context.method_51439(textRenderer, (class_2561)tmpText, tmpX, tmpY + 1, -16777216, false);
        context.method_51439(textRenderer, (class_2561)tmpText, tmpX, tmpY, -8323296, false);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX -= this.field_22793.method_27525((class_5348)tmpText), tmpY, -12566464, false);
        Objects.requireNonNull(this.field_22793);
        if (this.isInsideArea(mouse, tmpX, tmpY, startX, tmpY + 9)) {
            ArrayList<class_5481> lines = new ArrayList<class_5481>();
            lines.add(SkillsMod.createTranslatable("tooltip", "earned_points", activeCategory.getEarnedPoints()).method_30937());
            lines.add(SkillsMod.createTranslatable("tooltip", "spent_points", activeCategory.getSpentPoints() + (String)(activeCategory.getSpentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.getSpentPointsLimit())).method_30937());
            this.method_47414(lines);
        }
        int rightX = tmpX;
        if (activeCategory.getCurrentLevel() >= 0) {
            if (this.small) {
                tmpX = this.field_22789 - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (leftX + rightX - 182) / 2;
                tmpY = 43;
            }
            context.method_25302(ICONS_TEXTURE, tmpX, tmpY, 0, 64, 182, 5);
            int width = Math.min(182, (int)(this.getActiveCategory().getExperienceProgress() * 183.0f));
            if (width > 0) {
                context.method_25302(ICONS_TEXTURE, tmpX, tmpY, 0, 69, width, 5);
            }
            if (this.isInsideExperience(mouse, tmpX, tmpY)) {
                ArrayList<class_5481> lines = new ArrayList<class_5481>();
                lines.add(SkillsMod.createTranslatable("tooltip", "current_level", activeCategory.getCurrentLevel()).method_30937());
                lines.add(SkillsMod.createTranslatable("tooltip", "experience_progress", activeCategory.getCurrentExperience(), activeCategory.getRequiredExperience(), class_3532.method_15375((float)(activeCategory.getExperienceProgress() * 100.0f))).method_30937());
                lines.add(SkillsMod.createTranslatable("tooltip", "to_next_level", activeCategory.getExperienceToNextLevel()).method_30937());
                this.method_47414(lines);
            }
        }
    }
}

