/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.client.data.ClientFrameData;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.skill.SkillState;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientSkillCategoryData category;

    private ShowCategoryInPacket(ClientSkillCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(class_2540 buf) {
        ClientSkillCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientSkillCategoryData readCategory(class_2540 buf) {
        class_2960 id = buf.method_10810();
        class_2561 title = buf.method_10808();
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        class_2960 background = buf.method_10810();
        boolean exclusiveRoot = buf.readBoolean();
        int spentPointsLimit = buf.readInt();
        Map<String, ClientSkillDefinitionData> definitions = buf.method_34066(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionData::getId, definition -> definition));
        Map<String, ClientSkillData> skills = buf.method_34066(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillData::getId, skill -> skill));
        List normalConnections = buf.method_34066(ShowCategoryInPacket::readSkillConnection);
        List exclusiveConnections = buf.method_34066(ShowCategoryInPacket::readSkillConnection);
        int spentPoints = buf.readInt();
        int earnedPoints = buf.readInt();
        int currentLevel = Integer.MIN_VALUE;
        int currentExperience = Integer.MIN_VALUE;
        int requiredExperience = Integer.MIN_VALUE;
        if (buf.readBoolean()) {
            currentLevel = buf.readInt();
            currentExperience = buf.readInt();
            requiredExperience = buf.readInt();
        }
        return new ClientSkillCategoryData(id, title, icon, background, exclusiveRoot, spentPointsLimit, definitions, skills, normalConnections, exclusiveConnections, spentPoints, earnedPoints, currentLevel, currentExperience, requiredExperience);
    }

    public static ClientSkillDefinitionData readDefinition(class_2540 buf) {
        String id = buf.method_19772();
        class_2561 title = buf.method_10808();
        class_2561 description = buf.method_10808();
        class_2561 extraDescription = buf.method_10808();
        ClientFrameData frame = ShowCategoryInPacket.readFrameIcon(buf);
        ClientIconData icon = ShowCategoryInPacket.readSkillIcon(buf);
        float size = buf.readFloat();
        return new ClientSkillDefinitionData(id, title, description, extraDescription, frame, icon, size);
    }

    public static ClientIconData readSkillIcon(class_2540 buf) {
        String type = buf.method_19772();
        return buf.method_37436(class_2540::method_19772).flatMap(data -> JsonElementWrapper.parseString(data, JsonPath.createNamed("Client Skill Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "item" -> ClientIconData.ItemIconData.parse(rootElement).getSuccess();
            case "effect" -> ClientIconData.EffectIconData.parse(rootElement).getSuccess();
            case "texture" -> ClientIconData.TextureIconData.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientIconData.TextureIconData::createMissing);
    }

    public static ClientFrameData readFrameIcon(class_2540 buf) {
        String type = buf.method_19772();
        return buf.method_37436(class_2540::method_19772).flatMap(data -> JsonElementWrapper.parseString(data, JsonPath.createNamed("Client Frame Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "advancement" -> ClientFrameData.AdvancementFrameData.parse(rootElement).getSuccess();
            case "texture" -> ClientFrameData.TextureFrameData.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientFrameData.TextureFrameData::createMissing);
    }

    public static ClientSkillData readSkill(class_2540 buf) {
        String id = buf.method_19772();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.method_19772();
        boolean isRoot = buf.readBoolean();
        SkillState state = (SkillState)buf.method_10818(SkillState.class);
        return new ClientSkillData(id, x, y, definition, isRoot, state);
    }

    public static ClientSkillConnectionData readSkillConnection(class_2540 buf) {
        String skillAId = buf.method_19772();
        String skillBId = buf.method_19772();
        boolean bidirectional = buf.readBoolean();
        return new ClientSkillConnectionData(skillAId, skillBId, bidirectional);
    }

    public ClientSkillCategoryData getCategory() {
        return this.category;
    }
}

