/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.config.IconConfig;

public class GeneralConfig {
    private final class_2561 title;
    private final IconConfig icon;
    private final class_2960 background;
    private final boolean unlockedByDefault;
    private final boolean exclusiveRoot;
    private final int spentPointsLimit;

    private GeneralConfig(class_2561 title, IconConfig icon, class_2960 background, boolean unlockedByDefault, boolean exclusiveRoot, int spentPointsLimit) {
        this.title = title;
        this.icon = icon;
        this.background = background;
        this.unlockedByDefault = unlockedByDefault;
        this.exclusiveRoot = exclusiveRoot;
        this.spentPointsLimit = spentPointsLimit;
    }

    public static Result<GeneralConfig, Failure> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(GeneralConfig::parse);
    }

    public static Result<GeneralConfig, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optTitle = rootObject.get("title").andThen(JsonParseUtils::parseText).ifFailure(failures::add).getSuccess();
        Optional optIcon = rootObject.get("icon").andThen(IconConfig::parse).ifFailure(failures::add).getSuccess();
        Optional optBackground = rootObject.get("background").andThen(JsonParseUtils::parseIdentifier).ifFailure(failures::add).getSuccess();
        Optional<Boolean> optUnlockedByDefault = rootObject.getBoolean("unlocked_by_default").ifFailure(failures::add).getSuccess();
        Boolean exclusiveRoot = rootObject.getBoolean("exclusive_root").getSuccess().orElse(false);
        Integer spentPointsLimit = rootObject.get("spent_points_limit").getSuccess().flatMap(element -> element.getAsInt().ifFailure(failures::add).getSuccess()).orElse(Integer.MAX_VALUE);
        if (failures.isEmpty()) {
            return Result.success(new GeneralConfig((class_2561)optTitle.orElseThrow(), (IconConfig)optIcon.orElseThrow(), (class_2960)optBackground.orElseThrow(), optUnlockedByDefault.orElseThrow(), exclusiveRoot, spentPointsLimit));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public boolean isUnlockedByDefault() {
        return this.unlockedByDefault;
    }

    public boolean isExclusiveRoot() {
        return this.exclusiveRoot;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public int getSpentPointsLimit() {
        return this.spentPointsLimit;
    }
}

