/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.config.experience.ExperiencePerLevelConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;

public class ExperienceConfig {
    private final ExperiencePerLevelConfig experiencePerLevel;
    private final List<ExperienceSourceConfig> experienceSources;

    private ExperienceConfig(ExperiencePerLevelConfig experiencePerLevel, List<ExperienceSourceConfig> experienceSources) {
        this.experiencePerLevel = experiencePerLevel;
        this.experienceSources = experienceSources;
    }

    public static Result<Optional<ExperienceConfig>, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> ExperienceConfig.parse(rootObject, context));
    }

    public static Result<Optional<ExperienceConfig>, Failure> parse(JsonObjectWrapper rootObject, ConfigContext context) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Boolean enabled = rootObject.getBoolean("enabled").getSuccess().orElse(true);
        Optional optExperiencePerLevel = rootObject.get("experience_per_level").andThen(ExperiencePerLevelConfig::parse).ifFailure(failures::add).getSuccess();
        List experienceSources = rootObject.getArray("sources").andThen(array -> array.getAsList((i, element) -> ExperienceSourceConfig.parse(element, context)).mapFailure(ManyFailures::ofList)).ifFailure(failures::add).getSuccess().orElseGet(List::of);
        if (failures.isEmpty()) {
            if (enabled.booleanValue()) {
                return Result.success(Optional.of(new ExperienceConfig((ExperiencePerLevelConfig)optExperiencePerLevel.orElseThrow(), experienceSources)));
            }
            return Result.success(Optional.empty());
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    public int getRequiredExperience(int level) {
        return this.experiencePerLevel.getFunction().apply(level);
    }

    public int getCurrentExperience(int earnedExperience) {
        int level = 0;
        int requiredExperience;
        while (earnedExperience >= (requiredExperience = this.getRequiredExperience(level))) {
            earnedExperience -= requiredExperience;
            ++level;
        }
        return earnedExperience;
    }

    public int getCurrentLevel(int earnedExperience) {
        int level = 0;
        int requiredExperience;
        while (earnedExperience >= (requiredExperience = this.getRequiredExperience(level))) {
            earnedExperience -= requiredExperience;
            ++level;
        }
        return level;
    }

    public void dispose(MinecraftServer server) {
        for (ExperienceSourceConfig experienceSource : this.experienceSources) {
            experienceSource.dispose(server);
        }
    }

    public ExperiencePerLevelConfig getExperiencePerLevel() {
        return this.experiencePerLevel;
    }

    public List<ExperienceSourceConfig> getExperienceSources() {
        return this.experienceSources;
    }
}

