/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.expression.ArithmeticParser;

public class ExperiencePerLevelConfig {
    private final Function<Integer, Integer> function;

    private ExperiencePerLevelConfig(Function<Integer, Integer> function) {
        this.function = function;
    }

    public static Result<ExperiencePerLevelConfig, Failure> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(ExperiencePerLevelConfig::parse);
    }

    public static Result<ExperiencePerLevelConfig, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Result<JsonElementWrapper, Failure> maybeDataElement = rootObject.get("data");
        Optional optFunction = rootObject.get("type").andThen(typeElement -> typeElement.getAsString().andThen(type -> ExperiencePerLevelConfig.parseType(type, maybeDataElement, typeElement.getPath()))).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new ExperiencePerLevelConfig((Function)optFunction.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    private static Result<Function<Integer, Integer>, Failure> parseType(String type, Result<JsonElementWrapper, Failure> maybeDataElement, JsonPath typeElementPath) {
        return switch (type) {
            case "expression" -> ExperiencePerLevelConfig.parseExpression(maybeDataElement);
            case "values" -> ExperiencePerLevelConfig.parseValues(maybeDataElement);
            default -> Result.failure(typeElementPath.failureAt("Expected a valid condition type"));
        };
    }

    private static Result<Function<Integer, Integer>, Failure> parseExpression(Result<JsonElementWrapper, Failure> maybeDataElement) {
        return maybeDataElement.andThen(JsonElementWrapper::getAsObject).andThen(dataObject -> dataObject.get("expression")).andThen(expressionElement -> expressionElement.getAsString().andThen(expression -> ArithmeticParser.parse(expression, Set.of("level"))).mapSuccess(expression -> level -> {
            Double value = (Double)expression.eval(Map.ofEntries(Map.entry("level", Double.valueOf(level.intValue()))));
            if (Double.isFinite(value)) {
                return (int)Math.round(value);
            }
            for (String message : expressionElement.getPath().failureAt("Expression returned a value that is not finite").getMessages()) {
                SkillsMod.getInstance().getLogger().warn(message);
            }
            return 0;
        }));
    }

    private static Result<Function<Integer, Integer>, Failure> parseValues(Result<JsonElementWrapper, Failure> maybeDataElement) {
        return maybeDataElement.andThen(JsonElementWrapper::getAsObject).andThen(dataObject -> dataObject.getArray("values")).andThen(valueArray -> valueArray.getAsList((k, element) -> element.getAsInt()).mapFailure(ManyFailures::ofList)).mapSuccess(values -> level -> (Integer)values.get(Math.min(level, values.size() - 1)));
    }

    public Function<Integer, Integer> getFunction() {
        return this.function;
    }
}

