/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;

public class SkillConfig {
    private final String id;
    private final int x;
    private final int y;
    private final String definitionId;
    private final boolean isRoot;

    private SkillConfig(String id, int x, int y, String definitionId, boolean isRoot) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.definitionId = definitionId;
        this.isRoot = isRoot;
    }

    public static Result<SkillConfig, Failure> parse(String id, JsonElementWrapper rootElement, SkillDefinitionsConfig definitions) {
        return rootElement.getAsObject().andThen(rootObject -> SkillConfig.parse(id, rootObject, definitions));
    }

    public static Result<SkillConfig, Failure> parse(String id, JsonObjectWrapper rootObject, SkillDefinitionsConfig definitions) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<Integer> optX = rootObject.getInt("x").ifFailure(failures::add).getSuccess();
        Optional<Integer> optY = rootObject.getInt("y").ifFailure(failures::add).getSuccess();
        Optional optDefinitionId = rootObject.get("definition").andThen(definitionElement -> definitionElement.getAsString().andThen(definitionId -> {
            if (definitions.getById((String)definitionId).isPresent()) {
                return Result.success(definitionId);
            }
            return Result.failure(definitionElement.getPath().failureAt("Expected a valid definition"));
        })).ifFailure(failures::add).getSuccess();
        Boolean isRoot = rootObject.getBoolean("root").getSuccess().orElse(false);
        if (failures.isEmpty()) {
            return Result.success(new SkillConfig(id, optX.orElseThrow(), optY.orElseThrow(), (String)optDefinitionId.orElseThrow(), isRoot));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    public String getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public boolean isRoot() {
        return this.isRoot;
    }
}

