/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import net.puffish.skillsmod.api.json.JsonArrayWrapper;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.config.skill.SkillConnectionsGroupConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;

public class SkillConnectionsConfig {
    private final SkillConnectionsGroupConfig normal;
    private final SkillConnectionsGroupConfig exclusive;

    private SkillConnectionsConfig(SkillConnectionsGroupConfig normal, SkillConnectionsGroupConfig exclusive) {
        this.normal = normal;
        this.exclusive = exclusive;
    }

    public static Result<SkillConnectionsConfig, Failure> parse(JsonElementWrapper rootElement, SkillsConfig skills) {
        return rootElement.getAsObject().andThen(rootObject -> SkillConnectionsConfig.parse(rootObject, skills)).orElse(failure -> rootElement.getAsArray().andThen(rootArray -> SkillConnectionsConfig.parseLegacy(rootArray, skills)));
    }

    private static Result<SkillConnectionsConfig, Failure> parse(JsonObjectWrapper rootObject, SkillsConfig skills) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        SkillConnectionsGroupConfig normal = rootObject.get("normal").getSuccess().flatMap(element -> SkillConnectionsGroupConfig.parse(element, skills).ifFailure(failures::add).getSuccess()).orElseGet(SkillConnectionsGroupConfig::empty);
        SkillConnectionsGroupConfig exclusive = rootObject.get("exclusive").getSuccess().flatMap(element -> SkillConnectionsGroupConfig.parse(element, skills).ifFailure(failures::add).getSuccess()).orElseGet(SkillConnectionsGroupConfig::empty);
        if (failures.isEmpty()) {
            return Result.success(new SkillConnectionsConfig(normal, exclusive));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    private static Result<SkillConnectionsConfig, Failure> parseLegacy(JsonArrayWrapper rootArray, SkillsConfig skills) {
        return SkillConnectionsGroupConfig.parseLegacy(rootArray, skills).mapSuccess(normal -> new SkillConnectionsConfig((SkillConnectionsGroupConfig)normal, SkillConnectionsGroupConfig.empty()));
    }

    public SkillConnectionsGroupConfig getNormal() {
        return this.normal;
    }

    public SkillConnectionsGroupConfig getExclusive() {
        return this.exclusive;
    }
}

