/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.calculation;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.expression.ArithmeticParser;
import net.puffish.skillsmod.expression.Expression;
import net.puffish.skillsmod.expression.LogicParser;

public class Calculation {
    private final Expression<Boolean> condition;
    private final Expression<Double> expression;
    private final JsonPath expressionElementPath;

    private Calculation(Expression<Boolean> condition, Expression<Double> expression, JsonPath expressionElementPath) {
        this.condition = condition;
        this.expression = expression;
        this.expressionElementPath = expressionElementPath;
    }

    public static Result<Calculation, Failure> parse(JsonElementWrapper rootElement, Set<String> conditionVariables, Set<String> expressionVariables) {
        return rootElement.getAsObject().andThen(rootObject -> Calculation.parse(rootObject, conditionVariables, expressionVariables));
    }

    public static Result<Calculation, Failure> parse(JsonObjectWrapper rootObject, Set<String> conditionVariables, Set<String> expressionVariables) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Expression<Boolean> condition = rootObject.get("condition").getSuccess().flatMap(element -> element.getAsString().andThen(string -> LogicParser.parse(string, conditionVariables).mapFailure(failure -> failure.flatMap(msg -> element.getPath().failureAt((String)msg)))).ifFailure(failures::add).getSuccess()).orElse(p -> true);
        Optional<JsonElementWrapper> optExpressionElement = rootObject.get("expression").ifFailure(failures::add).getSuccess();
        Optional optExpression = optExpressionElement.flatMap(element -> element.getAsString().andThen(string -> ArithmeticParser.parse(string, expressionVariables).mapFailure(failure -> failure.flatMap(msg -> element.getPath().failureAt((String)msg)))).ifFailure(failures::add).getSuccess());
        if (failures.isEmpty()) {
            return Result.success(new Calculation(condition, (Expression)optExpression.orElseThrow(), optExpressionElement.orElseThrow().getPath()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    public boolean test(Map<String, Boolean> variables) {
        return this.condition.eval(variables);
    }

    public double eval(Map<String, Double> variables) {
        return this.expression.eval(variables);
    }

    public Optional<Integer> getValue(Map<String, Boolean> conditionVariables, Map<String, Double> expressionVariables) {
        if (this.test(conditionVariables)) {
            double value = this.eval(expressionVariables);
            if (Double.isFinite(value)) {
                return Optional.of((int)Math.round(value));
            }
            for (String message : this.expressionElementPath.failureAt("Expression returned a value that is not finite").getMessages()) {
                SkillsMod.getInstance().getLogger().warn(message);
            }
            return Optional.of(0);
        }
        return Optional.empty();
    }
}

