/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.expression;

import java.util.List;
import java.util.Set;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.SingleFailure;
import net.puffish.skillsmod.expression.BinaryOperator;
import net.puffish.skillsmod.expression.Expression;
import net.puffish.skillsmod.expression.FunctionOperator;
import net.puffish.skillsmod.expression.GroupOperator;
import net.puffish.skillsmod.expression.Parser;
import net.puffish.skillsmod.expression.UnaryOperator;

public class LogicParser {
    private static final List<BinaryOperator<Boolean>> LOGIC_BINARY = List.of(BinaryOperator.createLeft("|", 1, (l, r) -> v -> (Boolean)l.eval(v) != false || (Boolean)r.eval(v) != false), BinaryOperator.createLeft("&", 2, (l, r) -> v -> (Boolean)l.eval(v) != false && (Boolean)r.eval(v) != false));
    private static final List<UnaryOperator<Boolean>> LOGIC_UNARY = List.of(UnaryOperator.create("!", 3, e -> v -> (Boolean)e.eval(v) == false));
    private static final List<GroupOperator> LOGIC_GROUP = List.of(GroupOperator.create("(", ")"));
    private static final List<FunctionOperator<Boolean>> LOGIC_FUNCTION = List.of();

    public static Result<Expression<Boolean>, Failure> parse(String expression, Set<String> variables) {
        return Parser.parse(expression, LOGIC_UNARY, LOGIC_BINARY, LOGIC_GROUP, LOGIC_FUNCTION, token -> {
            if (variables.contains(token)) {
                return Result.success(v -> (Boolean)v.get(token));
            }
            return Result.failure(SingleFailure.of("Unknown variable `" + token + "`"));
        });
    }
}

