/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.rewards.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.rewards.Reward;
import net.puffish.skillsmod.api.rewards.RewardContext;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;

public class CommandReward
implements Reward {
    public static final class_2960 ID = SkillsMod.createIdentifier("command");
    private final Map<UUID, Integer> counts = new HashMap<UUID, Integer>();
    private final String command;
    private final String unlockCommand;
    private final String lockCommand;

    private CommandReward(String command, String unlockCommand, String lockCommand) {
        this.command = command;
        this.unlockCommand = unlockCommand;
        this.lockCommand = lockCommand;
    }

    public static void register() {
        SkillsAPI.registerRewardWithData(ID, CommandReward::create);
    }

    private static Result<CommandReward, Failure> create(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(CommandReward::create);
    }

    private static Result<CommandReward, Failure> create(JsonObjectWrapper rootObject) {
        String command = rootObject.getString("command").getSuccess().orElse("");
        String unlockCommand = rootObject.getString("unlock_command").getSuccess().orElse("");
        String lockCommand = rootObject.getString("lock_command").getSuccess().orElse("");
        return Result.success(new CommandReward(command, unlockCommand, lockCommand));
    }

    private void executeCommand(class_3222 player, String command) {
        if (command.isBlank()) {
            return;
        }
        MinecraftServer server = Objects.requireNonNull(player.method_5682());
        server.method_3734().method_44252(player.method_5671().method_9217().method_9206(server.method_21714()), command);
    }

    @Override
    public void update(class_3222 player, RewardContext context) {
        if (context.recent()) {
            this.executeCommand(player, this.command);
        }
        this.counts.compute(player.method_5667(), (uuid, count) -> {
            Integer n;
            if (count == null) {
                count = 0;
            }
            while (context.count() > count) {
                this.executeCommand(player, this.unlockCommand);
                n = count;
                count = count + 1;
            }
            while (context.count() < count) {
                this.executeCommand(player, this.lockCommand);
                n = count;
                count = count - 1;
            }
            return count;
        });
    }

    @Override
    public void dispose(MinecraftServer server) {
        for (Map.Entry<UUID, Integer> entry : this.counts.entrySet()) {
            class_3222 player = server.method_3760().method_14602(entry.getKey());
            if (player == null) continue;
            for (int i = 0; i < entry.getValue(); ++i) {
                this.executeCommand(player, this.lockCommand);
            }
        }
        this.counts.clear();
    }
}

