/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.rewards.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.rewards.Reward;
import net.puffish.skillsmod.api.rewards.RewardContext;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public class ScoreboardReward
implements Reward {
    public static final class_2960 ID = SkillsMod.createIdentifier("scoreboard");
    private final String objectiveName;

    private ScoreboardReward(String objectiveName) {
        this.objectiveName = objectiveName;
    }

    public static void register() {
        SkillsAPI.registerRewardWithData(ID, ScoreboardReward::create);
    }

    private static Result<ScoreboardReward, Failure> create(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(ScoreboardReward::create);
    }

    private static Result<ScoreboardReward, Failure> create(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<String> optScoreboard = rootObject.getString("scoreboard").ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new ScoreboardReward(optScoreboard.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public void update(class_3222 player, RewardContext context) {
        class_269 scoreboard = player.method_7327();
        class_266 objective = scoreboard.method_1165(this.objectiveName);
        if (objective != null) {
            scoreboard.method_1180(player.method_5820(), objective).method_1128(context.count());
        }
    }

    @Override
    public void dispose(MinecraftServer server) {
    }
}

