/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.rewards.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.rewards.Reward;
import net.puffish.skillsmod.api.rewards.RewardContext;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public class TagReward
implements Reward {
    public static final class_2960 ID = SkillsMod.createIdentifier("tag");
    private final String tag;

    private TagReward(String tag) {
        this.tag = tag;
    }

    public static void register() {
        SkillsAPI.registerRewardWithData(ID, TagReward::create);
    }

    private static Result<TagReward, Failure> create(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(TagReward::create);
    }

    private static Result<TagReward, Failure> create(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<String> optTag = rootObject.getString("tag").ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new TagReward(optTag.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public void update(class_3222 player, RewardContext context) {
        if (context.count() > 0) {
            player.method_5780(this.tag);
        } else {
            player.method_5738(this.tag);
        }
    }

    @Override
    public void dispose(MinecraftServer server) {
    }
}

