/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.config.VariantBlacklist;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.config.VariantWeights;
import com.github.nyuppo.mixin.MobEntityVariantsMixin;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1493;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1493.class})
public class WolfVariantsMixin
extends MobEntityVariantsMixin {
    private static final class_2940<String> VARIANT_ID = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13326);
    private static final String NBT_KEY = "Variant";

    @Override
    protected void onInitDataTracker(CallbackInfo ci) {
        ((class_1493)this).method_5841().method_12784(VARIANT_ID, (Object)"default");
    }

    @Override
    protected void onWriteCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10582(NBT_KEY, (String)((class_1493)this).method_5841().method_12789(VARIANT_ID));
    }

    @Override
    protected void onReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        ((class_1493)this).method_5841().method_12778(VARIANT_ID, (Object)nbt.method_10558(NBT_KEY));
    }

    @Override
    protected void onInitialize(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt, CallbackInfoReturnable<class_1315> ci) {
        String variant = this.getRandomVariant(world.method_8409());
        ((class_1493)this).method_5841().method_12778(VARIANT_ID, (Object)variant);
    }

    @Override
    protected void onTick(CallbackInfo ci) {
        if (((String)((class_1493)this).method_5841().method_12789(VARIANT_ID)).isEmpty()) {
            String variant = this.getRandomVariant(((class_1493)this).method_37908().method_8409());
            ((class_1493)this).method_5841().method_12778(VARIANT_ID, (Object)variant);
        }
    }

    @Inject(method={"createChild(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/passive/PassiveEntity;)Lnet/minecraft/entity/passive/WolfEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateChild(class_3218 world, class_1296 entity, CallbackInfoReturnable<class_1493> ci) {
        class_1493 child = (class_1493)class_1299.field_6055.method_5883((class_1937)world);
        String variant = "default";
        if (entity.method_6051().method_43048(10) != 0) {
            class_2487 thisNbt = new class_2487();
            ((class_1493)this).method_5647(thisNbt);
            class_2487 parentNbt = new class_2487();
            entity.method_5647(parentNbt);
            if (thisNbt.method_10545(NBT_KEY) && parentNbt.method_10545(NBT_KEY)) {
                String parentVariant;
                String thisVariant = thisNbt.method_10558(NBT_KEY);
                if (thisVariant.equals(parentVariant = parentNbt.method_10558(NBT_KEY))) {
                    variant = thisVariant;
                } else {
                    boolean hasBred = false;
                    if (thisVariant.equals("husky") && parentVariant.equals("jupiter") || thisVariant.equals("jupiter") && parentVariant.equals("husky")) {
                        if (entity.method_6051().method_43048(10) < VariantSettings.getWolfBreedingChance() && !VariantBlacklist.isBlacklisted("wolf", "german_shepherd")) {
                            hasBred = true;
                            variant = "german_shepherd";
                        }
                    } else if (thisVariant.equals("jupiter") && parentVariant.equals("default") || thisVariant.equals("default") && parentVariant.equals("jupiter")) {
                        if (entity.method_6051().method_43048(10) < VariantSettings.getWolfBreedingChance() && !VariantBlacklist.isBlacklisted("wolf", "golden_retriever")) {
                            hasBred = true;
                            variant = "golden_retriever";
                        }
                    } else if ((thisVariant.equals("husky") && parentVariant.equals("golden_retriever") || thisVariant.equals("golden_retriever") && parentVariant.equals("husky")) && entity.method_6051().method_43048(10) < VariantSettings.getWolfBreedingChance() && !VariantBlacklist.isBlacklisted("wolf", "french_bulldog")) {
                        hasBred = true;
                        variant = "french_bulldog";
                    }
                    if (!hasBred) {
                        variant = entity.method_6051().method_43056() ? thisVariant : parentVariant;
                    }
                }
            }
        } else {
            variant = this.getRandomVariant(entity.method_6051());
        }
        class_2487 childNbt = new class_2487();
        child.method_5647(childNbt);
        childNbt.method_10582(NBT_KEY, variant);
        child.method_5749(childNbt);
        ci.setReturnValue((Object)child);
    }

    private String getRandomVariant(class_5819 random) {
        return VariantWeights.getRandomVariant("wolf", random);
    }
}

