/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.uwrad.common;

import com.ishland.uwrad.common.Config;
import com.ishland.uwrad.common.debug.SMAPSourceDebugExtension;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_6575;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckedThreadLocalRandom
extends class_6575 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CheckedThreadLocalRandom");
    private static final ThreadLocal<class_6575> FALLBACK = ThreadLocal.withInitial(() -> new class_6575(new Random().nextLong()));
    private final Supplier<Thread> owner;

    public CheckedThreadLocalRandom(long seed, Supplier<Thread> owner) {
        super(seed);
        this.owner = Objects.requireNonNull(owner);
    }

    private boolean isSafe() {
        boolean notOwner;
        Thread owner = this.owner != null ? this.owner.get() : null;
        boolean bl = notOwner = owner != null && Thread.currentThread() != owner;
        if (notOwner) {
            this.handleNotOwner();
            return false;
        }
        return true;
    }

    private void handleNotOwner() {
        StringBuilder builder = new StringBuilder();
        String exceptionMessage = "ThreadLocalRandom accessed from a different thread (owner: %s, current: %s)".formatted(this.owner.get().getName(), Thread.currentThread().getName());
        builder.append(exceptionMessage).append('\n');
        builder.append("Possible solutions: Find possible causes in the stack trace below and report to the corresponding mod authors \n");
        ConcurrentModificationException exception = new ConcurrentModificationException(exceptionMessage);
        try {
            SMAPSourceDebugExtension.enhanceStackTrace(exception, false);
        }
        catch (Throwable t) {
            LOGGER.error("Error occurred while processing error stack trace", t);
            exception = new ConcurrentModificationException(exceptionMessage);
        }
        String s = builder.toString();
        LOGGER.error(s, (Throwable)exception);
        if (Config.ENFORCE_SAFE_WORLD_RANDOM_ACCESS) {
            throw new RuntimeException(String.format("%s \n (You may make this a fatal warning instead of a hard crash with enforce_safe_world_random_access setting in uwrad.properties)", s), exception){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
        }
    }

    public void method_43052(long seed) {
        if (this.isSafe()) {
            super.method_43052(seed);
        } else {
            FALLBACK.get().method_43052(seed);
        }
    }

    public int method_43156(int bits) {
        if (this.isSafe()) {
            return super.method_43156(bits);
        }
        return FALLBACK.get().method_43156(bits);
    }

    static {
        if (Config.ENFORCE_SAFE_WORLD_RANDOM_ACCESS) {
            LOGGER.info("Enforcing safe world random access");
        } else {
            LOGGER.warn("Not enforcing safe world random access");
        }
    }
}

