/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableMap;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.components.ConfigSelectionList;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.helper.ServerConfigUploader;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.network.client.C2SAskPermissionsMessage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraftforge.fml.config.ModConfig;

public class SelectConfigScreen
extends class_437 {
    private final class_437 lastScreen;
    private final class_2561 displayName;
    private final Map<ModConfig, Map<Object, IEntryData>> configs;
    private List<class_5481> activeTooltip;
    private class_342 searchBox;
    private ConfigSelectionList list;
    private class_4185 openButton;
    private class_4185 selectButton;
    private class_4185 restoreButton;
    private class_4185 copyButton;
    private class_4185 fileButton;
    private boolean serverPermissions;

    public SelectConfigScreen(class_437 lastScreen, class_2561 displayName, Set<ModConfig> configs) {
        super((class_2561)class_2561.method_43469((String)"configmenusforge.gui.select.title", (Object[])new Object[]{displayName}));
        this.lastScreen = lastScreen;
        this.displayName = displayName;
        this.configs = (Map)configs.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Function.identity(), IEntryData::makeValueToDataMap), ImmutableMap::copyOf));
    }

    public void method_49589() {
        this.initServerPermissions();
    }

    public void method_25393() {
        this.searchBox.method_1865();
    }

    protected void method_25426() {
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 121, 22, 242, 20, this.searchBox, (class_2561)class_2561.method_43473()){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.method_1885() && button == 1) {
                    this.method_1852("");
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
        this.searchBox.method_1863(filter -> this.list.updateFilter((String)filter));
        this.searchBox.method_1880(50);
        this.method_25429((class_364)this.searchBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431());
        this.openButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.edit"), button1 -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.method_25334();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                entry.openConfig();
            }
        }).method_46434(this.field_22789 / 2 - 50 - 104, this.field_22790 - 52, 100, 20).method_46431());
        this.selectButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.world.edit"), button1 -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.method_25334();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                entry.openConfig();
            }
        }).method_46434(this.field_22789 / 2 - 50 - 104, this.field_22790 - 52, 100, 20).method_46431());
        this.restoreButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.restore"), button1 -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.method_25334();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                class_5250 component2 = class_2561.method_43471((String)"configmenusforge.gui.message.restore.warning").method_27692(class_124.field_1061);
                class_410 confirmScreen = new class_410(result1 -> {
                    if (result1) {
                        ModConfig config = entry.getConfig();
                        this.getValueToDataMap(config).values().forEach(data -> {
                            data.resetCurrentValue();
                            data.saveConfigValue();
                        });
                        ServerConfigUploader.saveAndUpload(config);
                    }
                    this.field_22787.method_1507((class_437)this);
                }, (class_2561)class_2561.method_43471((String)"configmenusforge.gui.message.restore.title"), (class_2561)component2);
                this.field_22787.method_1507((class_437)confirmScreen);
            }
        }).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 52, 100, 20).method_46431());
        this.copyButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.copy"), button -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.method_25334();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                ModConfig config = entry.getConfig();
                Path destination = CommonAbstractions.INSTANCE.getDefaultConfigPath().resolve(config.getFileName());
                class_5250 component2 = Files.exists(destination, new LinkOption[0]) ? class_2561.method_43471((String)"configmenusforge.gui.message.copy.warning").method_27692(class_124.field_1061) : class_2561.method_43471((String)"configmenusforge.gui.message.copy.description");
                this.field_22787.method_1507((class_437)new class_410(result -> {
                    if (result) {
                        try {
                            if (!Files.exists(destination, new LinkOption[0])) {
                                try {
                                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                Files.createFile(destination, new FileAttribute[0]);
                            }
                            TomlFormat.instance().createWriter().write((UnmodifiableConfig)config.getConfigData(), destination, WritingMode.REPLACE);
                            ForgeConfigScreens.LOGGER.info("Successfully copied {} to default config folder", (Object)config.getFileName());
                        }
                        catch (Exception e) {
                            ForgeConfigScreens.LOGGER.error("Failed to copy {} to default config folder", (Object)config.getFileName(), (Object)e);
                        }
                    }
                    this.field_22787.method_1507((class_437)this);
                }, (class_2561)class_2561.method_43471((String)"configmenusforge.gui.message.copy.title"), (class_2561)component2));
            }
        }).method_46434(this.field_22789 / 2 - 50 + 104, this.field_22790 - 52, 100, 20).method_46431());
        this.fileButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.open"), button -> {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.method_25334();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11746, entry.getConfig().getFullPath().toAbsolutePath().toString()));
                this.method_25430(style);
            }
        }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        this.updateButtonStatus(false);
        this.list = new ConfigSelectionList(this, this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 60, 36, this.searchBox.method_1882(), this.list);
        this.method_25429((class_364)this.list);
        this.method_48265((class_364)this.searchBox);
    }

    public boolean method_25404(int i, int j, int k) {
        return super.method_25404(i, j, k) || this.searchBox.method_25404(i, j, k);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public boolean method_25400(char c, int i) {
        return this.searchBox.method_25400(c, i);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.list.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 7, 0xFFFFFF);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != null) {
            guiGraphics.method_51447(this.field_22793, this.activeTooltip, mouseX, mouseY);
        }
    }

    public void updateButtonStatus(boolean active) {
        if (this.list != null && active) {
            ConfigSelectionList.Entry selected = (ConfigSelectionList.Entry)this.list.method_25334();
            if (selected instanceof ConfigSelectionList.ConfigListEntry) {
                ConfigSelectionList.ConfigListEntry entry = (ConfigSelectionList.ConfigListEntry)selected;
                boolean needsWorldInstance = entry.needsWorldInstance();
                this.openButton.field_22764 = !needsWorldInstance;
                this.selectButton.field_22764 = needsWorldInstance;
                this.openButton.field_22763 = true;
                this.restoreButton.field_22763 = !needsWorldInstance && entry.mayResetValue();
                this.fileButton.field_22763 = !needsWorldInstance && !entry.onMultiplayerServer();
                this.copyButton.field_22763 = !needsWorldInstance;
            }
        } else {
            this.openButton.field_22764 = true;
            this.openButton.field_22763 = false;
            this.selectButton.field_22764 = false;
            this.restoreButton.field_22763 = false;
            this.fileButton.field_22763 = false;
            this.copyButton.field_22763 = false;
        }
    }

    public void setActiveTooltip(List<class_5481> list) {
        this.activeTooltip = list;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public Set<ModConfig> getConfigs() {
        return this.configs.keySet();
    }

    public Map<Object, IEntryData> getValueToDataMap(ModConfig config) {
        return this.configs.get(config);
    }

    private void initServerPermissions() {
        class_310 minecraft = class_310.method_1551();
        class_634 connection = minecraft.method_1562();
        if (connection != null) {
            if (minecraft.method_1542()) {
                this.serverPermissions = true;
            } else {
                NetworkingHelper.sendToServer(connection.method_48296(), new C2SAskPermissionsMessage());
            }
        }
    }

    public boolean getServerPermissions() {
        return this.serverPermissions;
    }

    public void setServerPermissions() {
        this.serverPermissions = true;
    }
}

