/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.components.ConfigWorldSelectionList;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraftforge.fml.config.ModConfig;

public class SelectConfigWorldScreen
extends class_437 {
    private final class_437 lastScreen;
    private final class_2561 displayName;
    private final ModConfig config;
    private final List<class_34> levelList;
    private List<class_5481> activeTooltip;
    private class_342 searchBox;
    private ConfigWorldSelectionList list;
    private class_4185 openButton;
    private class_4185 createButton;
    private class_4185 copyButton;
    private class_4185 fileButton;

    public SelectConfigWorldScreen(class_437 lastScreen, class_2561 displayName, ModConfig config, List<class_34> levelList) {
        super((class_2561)class_2561.method_43469((String)"configmenusforge.gui.select.world.title", (Object[])new Object[]{displayName}));
        this.lastScreen = lastScreen;
        this.displayName = displayName;
        this.config = config;
        if (levelList.isEmpty()) {
            throw new IllegalArgumentException("level list may not be empty, solve this beforehand");
        }
        this.levelList = levelList;
    }

    public void method_25393() {
        this.searchBox.method_1865();
    }

    protected void method_25426() {
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 121, 22, 242, 20, this.searchBox, (class_2561)class_2561.method_43473()){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.method_1885() && button == 1) {
                    this.method_1852("");
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
        this.searchBox.method_1863(query -> this.list.refreshList((String)query));
        this.searchBox.method_1880(50);
        this.method_25429((class_364)this.searchBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431());
        this.openButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.edit"), button1 -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.method_25334();
            if (selected != null) {
                selected.openConfig();
            }
        }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 52, 150, 20).method_46431());
        this.createButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.world.create"), button1 -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.method_25334();
            if (selected != null) {
                selected.openConfig();
            }
        }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 52, 150, 20).method_46431());
        this.copyButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.copy"), button -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.method_25334();
            if (selected != null) {
                selected.loadModConfig(this.config);
                Path destination = CommonAbstractions.INSTANCE.getDefaultConfigPath().resolve(this.config.getFileName());
                class_5250 component2 = Files.exists(destination, new LinkOption[0]) ? class_2561.method_43471((String)"configmenusforge.gui.message.copy.warning").method_27692(class_124.field_1061) : class_2561.method_43471((String)"configmenusforge.gui.message.copy.description");
                this.field_22787.method_1507((class_437)new class_410(result -> {
                    if (result) {
                        try {
                            if (!Files.exists(destination, new LinkOption[0])) {
                                try {
                                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                Files.createFile(destination, new FileAttribute[0]);
                            }
                            TomlFormat.instance().createWriter().write((UnmodifiableConfig)this.config.getConfigData(), destination, WritingMode.REPLACE);
                            ForgeConfigScreens.LOGGER.info("Successfully copied {} to default config folder", (Object)this.config.getFileName());
                        }
                        catch (Exception e) {
                            ForgeConfigScreens.LOGGER.error("Failed to copy {} to default config folder", (Object)this.config.getFileName(), (Object)e);
                        }
                    }
                    this.field_22787.method_1507((class_437)this);
                }, (class_2561)class_2561.method_43471((String)"configmenusforge.gui.message.copy.title"), (class_2561)component2));
            }
        }).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 52, 150, 20).method_46431());
        this.fileButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configmenusforge.gui.select.open"), button -> {
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.method_25334();
            if (selected != null) {
                selected.loadModConfig(this.config);
                class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11746, this.config.getFullPath().toAbsolutePath().toString()));
                this.method_25430(style);
            }
        }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        this.updateButtonStatus(false);
        this.list = new ConfigWorldSelectionList(this, this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 60, 36, this.searchBox.method_1882(), this.levelList);
        this.method_25429((class_364)this.list);
        this.method_48265((class_364)this.searchBox);
    }

    public boolean method_25404(int i, int j, int k) {
        return super.method_25404(i, j, k) || this.searchBox.method_25404(i, j, k);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public boolean method_25400(char pCodePoint, int pModifiers) {
        return this.searchBox.method_25400(pCodePoint, pModifiers);
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        this.activeTooltip = null;
        this.list.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.searchBox.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        if (this.activeTooltip != null) {
            guiGraphics.method_51447(this.field_22793, this.activeTooltip, pMouseX, pMouseY);
        }
    }

    public void setActiveTooltip(List<class_5481> list) {
        this.activeTooltip = list;
    }

    public void updateButtonStatus(boolean active) {
        if (this.list != null && active) {
            boolean fileExists;
            ConfigWorldSelectionList.ConfigWorldListEntry selected = (ConfigWorldSelectionList.ConfigWorldListEntry)this.list.method_25334();
            this.openButton.field_22764 = fileExists = selected.fileExists();
            this.createButton.field_22764 = !fileExists;
            this.openButton.field_22763 = true;
            this.fileButton.field_22763 = fileExists;
            this.copyButton.field_22763 = fileExists;
        } else {
            this.openButton.field_22764 = true;
            this.openButton.field_22763 = false;
            this.createButton.field_22764 = false;
            this.fileButton.field_22763 = false;
            this.copyButton.field_22763 = false;
        }
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public void method_25432() {
        if (this.list != null) {
            this.list.method_25396().forEach(ConfigWorldSelectionList.ConfigWorldListEntry::close);
        }
    }
}

