/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.network;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.network.S2CGrantPermissionsMessage;
import fuzs.forgeconfigscreens.network.S2CUpdateConfigMessage;
import fuzs.forgeconfigscreens.network.client.C2SAskPermissionsMessage;
import fuzs.forgeconfigscreens.network.client.C2SSendConfigMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public final class ServerMessageHandles {
    private ServerMessageHandles() {
    }

    public static void handleAskPermissions(C2SAskPermissionsMessage message, MinecraftServer server, class_3244 handler, class_3222 player, class_3218 level) {
        if (player.method_5687(server.method_3798())) {
            NetworkingHelper.sendTo(player, new S2CGrantPermissionsMessage());
        }
    }

    public static void handleSendConfig(C2SSendConfigMessage packet, MinecraftServer server, class_3244 handler, class_3222 player, class_3218 level) {
        if (server.method_3816() && player.method_5687(server.method_3798())) {
            ModConfig config = (ModConfig)ConfigTracker.INSTANCE.fileMap().get(packet.fileName());
            if (config != null) {
                CommentedConfig receivedConfig = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(packet.fileData()));
                config.getConfigData().putAll((UnmodifiableConfig)receivedConfig);
                config.save();
                config.getSpec().afterReload();
                CommonAbstractions.INSTANCE.fireReloadingEvent(config);
                NetworkingHelper.sendToAllExcept(server, player, new S2CUpdateConfigMessage(packet.fileName(), packet.fileData()));
                ForgeConfigScreens.LOGGER.info("Server config has been updated by {}", (Object)player.method_5476().getString());
            } else {
                ForgeConfigScreens.LOGGER.error("Failed to update server config with data received from {}", (Object)player.method_5476().getString());
            }
        }
    }
}

